package com.transsion.ad.test

import android.os.Bundle
import android.util.Log
import androidx.lifecycle.lifecycleScope
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.banner.BiddingBannerManager
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.databinding.ActivityTestAdBannerLayoutBinding
import com.transsion.ad.log.AdLogger
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/6/5 17:17
 * @description:
 */
class TestAdBannerActivity : TestBaseActivity() {

    private lateinit var binding: ActivityTestAdBannerLayoutBinding
    private var bannerManager: BiddingBannerManager? = null

    private val bannerListener = object : BiddingTAdditionalListener() {

        override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingLoad(maxEcpmObject)
            lifecycleScope.launch {
                maxEcpmObject?.bannerView?.let {
                    bannerManager?.showBannerAd()
                    binding.flBannerContainer.addView(it)
                }
            }
        }

        override fun onBiddingError(p0: TAdErrorCode?) {
            super.onBiddingError(p0)
            onLog(
                level = Log.ERROR,
                msg = "onBiddingError() --> Banner 广告加载失败 --> errorMessage = ${p0?.errorMessage}"
            )
        }
    }


    // =============================================================================================


    override fun getLogTag(): String = AdLogger.TAG_AD_BANNER

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdBannerLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.btnLoadBannerAd.setOnClickListener {
            lifecycleScope.launch {
                bannerManager?.destroy()
                bannerManager = BiddingBannerManager()
                bannerManager?.setSceneId("MBNativeTestId")
                bannerManager?.setCtxMap(null)
                bannerManager?.setContext(this@TestAdBannerActivity)
                bannerManager?.setListener(bannerListener)
                bannerManager?.loadAd()
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        bannerManager?.destroy()
    }

}