package com.transsion.ad.util

import java.text.SimpleDateFormat
import java.util.Calendar
import java.util.Date
import java.util.Locale

/**
 * @author: zhangxinbing
 * @date : 2024/12/25 11:03
 * @description: 时间判断
 */
object TimeUtil {

    /**
     * 当前时间 是否在时间段里面 默认返回false
     */
    fun isCurrentTimeInRange(strStart: String, strEnd: String): Boolean {
        return kotlin.runCatching {
            // 目标时间范围
            val dateFormat = SimpleDateFormat("HH:mm:ss", Locale.getDefault())
            val startTime = dateFormat.parse(strStart)
            val endTime = dateFormat.parse(strEnd)

            // 获取当前时间
            val currentTime = dateFormat.parse(dateFormat.format(Date()))

            // 检查当前时间是否在范围内
            if (currentTime == null) {
                false
            } else {
                currentTime.after(startTime) && currentTime.before(endTime)
            }
        }.getOrElse {
            false
        }
    }

    /**
     * 获取当前日期
     */
    fun getCurrentDate(): String {
        val currentDate = Calendar.getInstance().time
        val formatter = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())
        return formatter.format(currentDate)
    }

    /**
     * 获取当前的时间戳
     */
    fun getCurrentTimestamp(): Long {
        val date = Date()
        return date.time
    }

    /**
     * 时间戳转日期
     * yyyy-MM-dd HH:mm:ss
     */
    fun convertTimestampToDate(
        timestampInSeconds: Long?, dateFormat: String = "yyyy-MM-dd"
    ): String {
        // 将时间戳（秒）转换为毫秒
        val timestampInMilliseconds = (timestampInSeconds ?: 0)
        // 创建 Date 对象
        val date = Date(timestampInMilliseconds)
        // 定义日期格式
        val sdf = SimpleDateFormat(dateFormat, Locale.getDefault())
        // 转换为字符串
        return sdf.format(date)
    }

    /**
     * 计算两个时间戳之间的时间差，返回格式为 x天 x小时 x分钟 x秒
     * @param startTime 开始时间，单位毫秒
     * @param endTime 结束时间，单位毫秒
     * @return 格式化后的时间差字符串
     */
    fun getTimeDifference(startTime: Long, endTime: Long): String {
        val diffMillis = kotlin.math.abs(endTime - startTime)

        val days = diffMillis / (1000 * 60 * 60 * 24)
        val hours = (diffMillis / (1000 * 60 * 60)) % 24
        val minutes = (diffMillis / (1000 * 60)) % 60
        val seconds = (diffMillis / 1000) % 60

        return "${days}天 ${hours}小时 ${minutes}分钟 ${seconds}秒"
    }

}