/***
 * #author
 * #data
 * ======================================
 * Copyright (c) 2018 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
package com.transsnet.launcherlib;


import android.os.Parcel;
import android.os.Parcelable;

public class CommonAppInfo implements Parcelable {
    private String title;
    private int descVersion;
    private String description;
    private String subDescription;

    private String iconUrl;
    private int category; //APP 类别

    private String downloadUrl;
    private String pkgName;
    private String versionName;
    private int versionCode;
    private long size;//用byte做单位

    private String starLevel; //apk推荐星级

    public CommonAppInfo() {}

    protected CommonAppInfo(Parcel in) {
        title = in.readString();
        descVersion = in.readInt();
        description = in.readString();
        subDescription = in.readString();
        iconUrl = in.readString();
        category = in.readInt();
        downloadUrl = in.readString();
        pkgName = in.readString();
        versionName = in.readString();
        versionCode = in.readInt();
        size = in.readLong();
        starLevel = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(title);
        dest.writeInt(descVersion);
        dest.writeString(description);
        dest.writeString(subDescription);
        dest.writeString(iconUrl);
        dest.writeInt(category);
        dest.writeString(downloadUrl);
        dest.writeString(pkgName);
        dest.writeString(versionName);
        dest.writeInt(versionCode);
        dest.writeLong(size);
        dest.writeString(starLevel);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<CommonAppInfo> CREATOR = new Creator<CommonAppInfo>() {
        @Override
        public CommonAppInfo createFromParcel(Parcel in) {
            return new CommonAppInfo(in);
        }

        @Override
        public CommonAppInfo[] newArray(int size) {
            return new CommonAppInfo[size];
        }
    };

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getDescVersion() {
        return descVersion;
    }

    public void setDescVersion(int descVersion) {
        this.descVersion = descVersion;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSubDescription() {
        return subDescription;
    }

    public void setSubDescription(String subDescription) {
        this.subDescription = subDescription;
    }

    public int getCategory() {
        return category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getPkgName() {
        return pkgName;
    }

    public void setPkgName(String pkgName) {
        this.pkgName = pkgName;
    }

    public String getVersionName() {
        return versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public int getVersionCode() {
        return versionCode;
    }

    public void setVersionCode(int versionCode) {
        this.versionCode = versionCode;
    }

    public long getSize() {
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getStarLevel() {
        return starLevel;
    }

    public void setStarLevel(String starLevel) {
        this.starLevel = starLevel;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }
}
