/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.hi;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.transsion.ad.R;

public class MaskLayout
extends FrameLayout {
    Drawable maskDrawable;
    Paint maskPaint;

    public MaskLayout(@NonNull Context context) {
        this(context, null);
    }

    public MaskLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.MaskLayout);
        this.maskDrawable = array.getDrawable(R.styleable.MaskLayout_xhg_mask_drawable);
        array.recycle();
        this.maskPaint = new Paint(1);
        this.maskPaint.setFilterBitmap(true);
        this.maskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        this.setWillNotDraw(false);
    }

    public void draw(Canvas canvas) {
        if (this.maskDrawable != null) {
            int width = this.getMeasuredWidth();
            int height = this.getMeasuredHeight();
            if (Build.VERSION.SDK_INT >= 26) {
                canvas.saveLayer(0.0f, 0.0f, (float)width, (float)height, null);
            } else {
                canvas.saveLayer(0.0f, 0.0f, (float)width, (float)height, null, 31);
            }
            this.maskDrawable.setBounds(this.getPaddingLeft(), this.getPaddingTop(), width - this.getPaddingRight(), height - this.getPaddingBottom());
            this.maskDrawable.draw(canvas);
            if (Build.VERSION.SDK_INT >= 26) {
                canvas.saveLayer(0.0f, 0.0f, (float)width, (float)height, this.maskPaint);
            } else {
                canvas.saveLayer(0.0f, 0.0f, (float)width, (float)height, this.maskPaint, 31);
            }
            super.draw(canvas);
            canvas.restore();
            canvas.restore();
        } else {
            super.draw(canvas);
        }
    }
}

