/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.strategy;

import com.transsion.ad.scene.SceneCommonConfig;
import com.transsion.ad.strategy.AdMmkv;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/transsion/ad/strategy/DisplayIntervalTimeManager;", "", "<init>", "()V", "MMKV_KEY", "", "canShow", "", "sceneId", "saveShowTime", "", "lib_ad_release"})
public final class DisplayIntervalTimeManager {
    @NotNull
    public static final DisplayIntervalTimeManager INSTANCE = new DisplayIntervalTimeManager();
    @NotNull
    private static final String MMKV_KEY = "DISPLAY_INTERVAL_TIME";

    private DisplayIntervalTimeManager() {
    }

    public final boolean canShow(@NotNull String sceneId) {
        Intrinsics.checkNotNullParameter((Object)sceneId, (String)"sceneId");
        long lastTime = AdMmkv.INSTANCE.getAdMMKV().getLong(MMKV_KEY + sceneId, 0L);
        if (lastTime == 0L) {
            return true;
        }
        int intervalTime = SceneCommonConfig.INSTANCE.getDisplayIntervalTime(sceneId);
        return System.currentTimeMillis() - lastTime >= (long)(intervalTime * 1000);
    }

    public final void saveShowTime(@NotNull String sceneId) {
        Intrinsics.checkNotNullParameter((Object)sceneId, (String)"sceneId");
        AdMmkv.INSTANCE.getAdMMKV().putLong(MMKV_KEY + sceneId, System.currentTimeMillis());
    }
}

