/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u001f\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b\u00a8\u0006\u0013"}, d2={"Lcom/transsion/ad/util/TimeUtil;", "", "<init>", "()V", "isCurrentTimeInRange", "", "strStart", "", "strEnd", "getCurrentDate", "getCurrentTimestamp", "", "convertTimestampToDate", "timestampInSeconds", "dateFormat", "(Ljava/lang/Long;Ljava/lang/String;)Ljava/lang/String;", "getTimeDifference", "startTime", "endTime", "lib_ad_release"})
public final class TimeUtil {
    @NotNull
    public static final TimeUtil INSTANCE = new TimeUtil();

    private TimeUtil() {
    }

    public final boolean isCurrentTimeInRange(@NotNull String strStart, @NotNull String strEnd) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)strStart, (String)"strStart");
        Intrinsics.checkNotNullParameter((Object)strEnd, (String)"strEnd");
        try {
            boolean bl = false;
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
            Date startTime = dateFormat.parse(strStart);
            Date endTime = dateFormat.parse(strEnd);
            Date currentTime = dateFormat.parse(dateFormat.format(new Date()));
            object2 = Result.constructor-impl((Object)(currentTime == null ? false : currentTime.after(startTime) && currentTime.before(endTime)));
        }
        catch (Throwable dateFormat) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)dateFormat));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = false;
        }
        return (Boolean)object;
    }

    @NotNull
    public final String getCurrentDate() {
        Date currentDate = Calendar.getInstance().getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        String string2 = formatter.format(currentDate);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public final long getCurrentTimestamp() {
        Date date = new Date();
        return date.getTime();
    }

    @NotNull
    public final String convertTimestampToDate(@Nullable Long timestampInSeconds, @NotNull String dateFormat) {
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        Long l = timestampInSeconds;
        long timestampInMilliseconds = l != null ? l : 0L;
        Date date = new Date(timestampInMilliseconds);
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.getDefault());
        String string2 = sdf.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static /* synthetic */ String convertTimestampToDate$default(TimeUtil timeUtil, Long l, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "yyyy-MM-dd";
        }
        return timeUtil.convertTimestampToDate(l, string2);
    }

    @NotNull
    public final String getTimeDifference(long startTime, long endTime) {
        long diffMillis = Math.abs(endTime - startTime);
        long days = diffMillis / (long)86400000;
        long hours = diffMillis / (long)3600000 % (long)24;
        long minutes = diffMillis / (long)60000 % (long)60;
        long seconds = diffMillis / (long)1000 % (long)60;
        return days + "\u5929 " + hours + "\u5c0f\u65f6 " + minutes + "\u5206\u949f " + seconds + "\u79d2";
    }
}

