/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import com.transsion.ad.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0014J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\b\u0010\u0015\u001a\u00020\rH\u0002R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/transsion/ad/view/GradientTextView;", "Landroidx/appcompat/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "startColor", "endColor", "onLayout", "", "changed", "", "left", "top", "right", "bottom", "setGradientColors", "updateShader", "lib_ad_release"})
public class GradientTextView
extends AppCompatTextView {
    private int startColor;
    private int endColor;

    @JvmOverloads
    public GradientTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.startColor = ContextCompat.getColor((Context)context, (int)R.color.ad_white_6);
        this.endColor = ContextCompat.getColor((Context)context, (int)R.color.ad_bg_01);
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet it = attributeSet;
            boolean bl = false;
            TypedArray typedArray = context.obtainStyledAttributes(it, R.styleable.GradientTextView);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray typedArray2 = typedArray;
            this.startColor = typedArray2.getColor(R.styleable.GradientTextView_startColor, this.startColor);
            this.endColor = typedArray2.getColor(R.styleable.GradientTextView_endColor, this.endColor);
            typedArray2.recycle();
        }
        this.updateShader();
    }

    public /* synthetic */ GradientTextView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.updateShader();
        }
    }

    public final void setGradientColors(int startColor, int endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.updateShader();
    }

    private final void updateShader() {
        int[] nArray = new int[]{this.startColor, this.endColor, this.endColor};
        LinearGradient shader = new LinearGradient(0.0f, 0.0f, (float)this.getWidth(), 0.0f, nArray, null, Shader.TileMode.CLAMP);
        this.getPaint().setShader((Shader)shader);
        this.invalidate();
    }

    @JvmOverloads
    public GradientTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GradientTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

