package com.transsion.ad

import com.blankj.utilcode.util.Utils
import java.io.File

/**
 * @author: zhangxinbing
 * @date : 2023/12/11 15:06
 * @description: 广告使用到的全局常量
 */
object MbAdContents {

    /**
     * 广告相关埋点 event
     */
    const val AD_EVENT_AD_LINK = "ad_link"

    /**
     * 包断广告素材下载地址
     */
    internal val NON_AD_VIDEO_DOWNLOAD_FILE_PATH =
        Utils.getApp().getExternalFilesDir("mb")?.absolutePath + File.separatorChar + "non_ad"

    /**
     * PS 直投 素材地址
     */
    internal val NON_AD_PS_DOWNLOAD_FILE_PATH =
        Utils.getApp().getExternalFilesDir("ps")?.absolutePath + File.separatorChar + "non_ad"


    internal const val NON_AD_PLAN_VERSION = "non_ad_plan_version"    // 广告计划版本号
    internal const val NON_AD_SCENE_VERSION = "non_ad_scene_version"  // 场景版本号
    internal const val MMKV_KEY_AD_SCENE_CONFIG_DATA = "non_ad_scene_config_data" // 场景数据保存


    internal const val MINE_TYPE = "mineType" // 包断广告缓存文件后缀

    const val DEFAULT_COUNT_DOWN_SECONDS = 5 // 默认倒计时

    const val WEB_ACTIVITY_EXTRA_LOG_TAG_KEY = "web_activity_extra_log_tag_key"
}