package com.transsion.ad.bidding.splash

import android.annotation.SuppressLint
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import com.gyf.immersionbar.BarHide
import com.gyf.immersionbar.ImmersionBar
import com.hisavana.common.interfacz.OnSkipListener
import com.transsion.ad.databinding.ActivityBiddingHisavanaSplashBinding
import com.transsion.ad.log.AdLogger

/**
 * @author Connor
 * @date : 2025/10/27 10:31
 * @description: Hi程序化开屏广告
 */
@SuppressLint("CustomSplashScreen")
class BiddingHisavanaSplashActivity : AppCompatActivity(), OnSkipListener {
    private var binding: ActivityBiddingHisavanaSplashBinding? = null
    private var splashProvider: BiddingHiSavanaSplashProvider? = null

    // 倒计时是否已结束
    private var isTimeReached = false
    // 前台状态标志
    private var isForeground = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val immersionBar = ImmersionBar.with(this)
        immersionBar.transparentBar()
        immersionBar.hideBar(BarHide.FLAG_SHOW_BAR)
        immersionBar.init()

        binding = ActivityBiddingHisavanaSplashBinding.inflate(layoutInflater)
        setContentView(binding?.root)

        val sceneId = intent.getStringExtra(BiddingHiSavanaSplashProvider.KEY_SCENE_ID)
        splashProvider = BiddingHiSavanaSplashProvider.getManager(sceneId)

        val logo: View? = LayoutInflater.from(this@BiddingHisavanaSplashActivity)
            .inflate(splashProvider?.getLogoLayout() ?: 0, binding?.splashAd, false)
        splashProvider?.showSplashAd(this,binding?.splashAd, logo)
    }

    override fun onResume() {
        super.onResume()
        isForeground = true
        if (isTimeReached) {
            finish()
        }
    }

    override fun onStop() {
        super.onStop()
        isForeground = false
    }

    override fun onDestroy() {
        super.onDestroy()
        AdLogger.logSdk(
            tag = AdLogger.TAG_AD_SPLASH, msg = "BiddingHisavanaSplashActivity --> onDestroy"
        )
        splashProvider?.reset()
    }

    /**
     * 点击跳过按钮
     */
    override fun onClick() {
        AdLogger.logSdk(
            tag = AdLogger.TAG_AD_SPLASH, msg = "BiddingHisavanaSplashActivity --> onSkipClick"
        )
        finish()
    }

    /**
     * 倒计时结束
     */
    override fun onTimeReach() {
        AdLogger.logSdk(
            tag = AdLogger.TAG_AD_SPLASH, msg = "BiddingHisavanaSplashActivity --> onTimeReach"
        )
        // 仅在前台时(含pause状态)执行finish
        if (isForeground) {
            finish()
        } else {
            isTimeReached = true
        }
    }
}