package com.transsion.ad.strategy

import com.tencent.mmkv.MMKV

/**
 * @author: zhangxinbing
 * @date : 2024/6/28 10:41
 * @description: 广告相关数据序列化
 */
object AdMmkv {

    /**
     * 通过会员状态来判断是否跳过广告展示
     */
    const val AD_MMKV_KEY_IS_SKIP_AD = "kv_is_skip_ad"

    /**
     * 会员模式下，广告场景ID白名单列表
     */
    const val AD_MMKV_KEY_MEMBER_SCENE_ID_WHIT_LIST = "member_scene_id_whit_list"


    // =============================================================================================


    /**
     * 保存广告相关数据的
     *
     * TODO 依赖宿主初始化
     */
    val mmkvWithID: MMKV by lazy {
        MMKV.mmkvWithID("one_room_advertising")
    }

    fun getAdMMKV(): MMKV = mmkvWithID

}