package com.transsion.ad.test

import android.os.Bundle
import android.util.Log
import androidx.lifecycle.lifecycleScope
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.video.BiddingVideoManager
import com.transsion.ad.databinding.ActivityTestAdVideoLayoutBinding
import com.transsion.ad.log.AdLogger
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/6/9 10:42
 * @description:
 */
class TestAdVideoActivity : TestBaseActivity() {

    private lateinit var videoManager: BiddingVideoManager
    private lateinit var binding: ActivityTestAdVideoLayoutBinding

    private val videoListener = object : BiddingTAdditionalListener() {

        override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingLoad(maxEcpmObject)
            videoManager.startAdActivity(this@TestAdVideoActivity,maxEcpmObject)
        }

        override fun onBiddingError(p0: TAdErrorCode?) {
            super.onBiddingError(p0)
            onLog(level = Log.ERROR, msg = "onBiddingError() --> p0 = ${p0?.errorMessage}")
        }

        override fun onBiddingWrapperAdShowError(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingWrapperAdShowError(maxEcpmObject)
            onLog(level = Log.ERROR, msg = "onBiddingWrapperAdShowError() --> 展示失败")
        }
    }


    // =============================================================================================


    override fun getLogTag(): String = AdLogger.TAG_AD_VIDEO

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdVideoLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        videoManager = BiddingVideoManager()
        binding.btnLoadVideoAd.setOnClickListener {
            lifecycleScope.launch {
                videoManager.setSceneId("MBNativeTestId")
                videoManager.setCtxMap(null)
                videoManager.setContext(this@TestAdVideoActivity)
                videoManager.setListener(videoListener)
                videoManager.loadAd()
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        videoManager.destroy()
    }

}