package com.transsion.ad.util

import android.app.ActivityManager
import android.content.Context
import android.os.Process

/**
 * @author shmizhangxinbing
 * @date : 2025/11/24 11:17
 * @description:
 */
object ProcessUtil {

    /**
     * 获取当前进程名
     */
    fun getCurrentProcessName(context: Context?): String? {
        val pid = Process.myPid()
        val am = context?.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager
        am.runningAppProcesses?.forEach { process ->
            if (process.pid == pid) {
                return process.processName
            }
        }
        return null
    }

}