package com.transsion.ad.util

import android.view.View
import android.view.ViewGroup

/**
 * @author: zhangxinbing
 * @date : 2025/2/18 20:41
 * @description:
 */
object ViewUtil {

    /**
     * 从父 view 中移除自己
     * @param child
     */
    fun removeSelfFromParent(child: View?) {
        (child?.parent as? ViewGroup)?.removeView(child)
    }

    /***多View同源点击事件*/
    fun multipleClickListener(vararg view: View?, click: View.OnClickListener) {
        view.forEach {
            it?.setOnClickListener(click)
        }
    }

    /**
     * 判断View或ViewGroup自身是否可以滑动
     */
    fun isScrollable(view: View): Boolean {
        return view.canScrollVertically(1) || view.canScrollVertically(-1) || view.canScrollHorizontally(
            1
        ) || view.canScrollHorizontally(-1)
    }

    /**
     * 递归判断ViewGroup及其所有子View是否有可以滑动的
     */
    fun hasAnyScrollable(view: View): Boolean {
        if (isScrollable(view)) {
            return true
        }
        if (view is ViewGroup) {
            for (i in 0 until view.childCount) {
                val child = view.getChildAt(i)
                if (hasAnyScrollable(child)) {
                    return true
                }
            }
        }
        return false
    }

}