package com.transsion.ad.view

import android.content.Context
import android.graphics.Typeface
import android.util.AttributeSet
import android.view.Gravity
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.core.content.ContextCompat
import com.blankj.utilcode.util.SizeUtils
import com.transsion.ad.R

/**
 * @author shmizhangxinbing
 * @date : 2025/8/27 20:11
 * @description:
 */
class MemberTagView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0,
) : LinearLayout(context, attrs, defStyleAttr) {


    init {

        val textView = TextView(context).apply {
            // 设置宽高为 wrap_content

            text = "Go ad-free"
            setTypeface(typeface, Typeface.BOLD) // 设置加粗
            setTextColor(ContextCompat.getColor(context, R.color.ad_yellow_light_50))
            textSize = 12f // 单位为sp
            // 如果有自定义样式，可以手动设置相关属性
            // 例如：setPadding()、setBackgroundResource()等
        }
        val textLayoutParams = LayoutParams(
            LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT
        )
        textLayoutParams.gravity = Gravity.CENTER_VERTICAL
        addView(textView, textLayoutParams)

        val arrow = ImageView(context).apply {
            setImageResource(R.mipmap.ad_member_arrow_right)
        }
        // 设置宽高为 wrap_content
        val arrowLayoutParams = LayoutParams(
            SizeUtils.dp2px(14f), SizeUtils.dp2px(14f)
        )
        arrowLayoutParams.marginStart = SizeUtils.dp2px(2f)
        arrowLayoutParams.gravity = Gravity.CENTER_VERTICAL
        addView(arrow, arrowLayoutParams)
    }

}