package com.transsion.ad.view.native_ad

import android.app.Activity
import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.util.Log
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.transsion.ad.bidding.base.AbsBiddingAdLayoutProvider
import com.transsion.ad.bidding.base.AbsBiddingBuyOutView
import com.transsion.ad.bidding.base.BiddingAdLayoutProviderBean
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.strategy.AdTagManager
import com.transsion.ad.util.DebounceClickListener
import com.transsion.ad.view.AdTagView
import com.transsion.ad.view.blur.BlurTransformation

/**
 * @author shmizhangxinbing
 * @date : 2025/5/29 17:45
 * @description:
 */
class BiddingBuyOutNativeView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
) : AbsBiddingBuyOutView(context, attrs) {

    private var adProviderBean: BiddingAdLayoutProviderBean? = null
    private var mIsShowVolumeIcon: Boolean = true


    // =============================================================================================


    override fun getMediaContainer(): FrameLayout? {
        adProviderBean?.mediaId?.let { mediaId ->
            return adProviderBean?.layout?.findViewById(mediaId)
        }
        adProviderBean?.iconId?.let { mediaId ->
            return adProviderBean?.layout?.findViewById(mediaId)
        }
        return null
    }

    override fun isShowVolumeIcon(): Boolean = mIsShowVolumeIcon

    override fun getLogTag(): String = AdLogger.TAG_AD_NATIVE


    // =============================================================================================


    /**
     * 渲染视图
     */
    fun bindNativeView(adLayoutProvider: AbsBiddingAdLayoutProvider?) {

        // 数据校验
        if (getAdPlans() == null || adLayoutProvider == null) {
            return
        }

        // 修复线上问题
        // 在Android中使用Glide加载图片时，如果传入的context是view的context，可能会导致上述的IllegalArgumentException。
        // 这是因为view的context可能与Activity的生命周期不同步。
        if ((context as? Activity)?.isDestroyed == true) {
            onLog(
                level = Log.WARN,
                msg = "bindNativeView() --> 当前Activity销毁，广告就不需要展示了",
                writeToFile = false
            )
            return
        }

        val adProviderBean = adLayoutProvider.getAdLayoutProvider()
        this.adProviderBean = adProviderBean
        this.mIsShowVolumeIcon = adLayoutProvider.isShowVolumeIcon()

        //设置标题
        adProviderBean.titleId?.let { titleId ->
            adProviderBean.layout.findViewById<TextView>(titleId)?.apply {
                text = getAdMaterialList()?.title
            }
        }

        // 设置描述
        adProviderBean.descriptionId?.let { descriptionId ->
            adProviderBean.layout.findViewById<TextView>(descriptionId)?.apply {
                text = getAdMaterialList()?.desc
            }
        }

        // 按钮文案点击事件
        adProviderBean.callToActionId?.let { callToActionId ->
            adProviderBean.layout.findViewById<TextView>(callToActionId)?.apply {
                if (TextUtils.isEmpty(getAdMaterialList()?.buttonText)) {
                    getAdMaterialList()?.buttonText = "GO"
                }
                text = getAdMaterialList()?.buttonText
                setOnClickListener(DebounceClickListener {
                    onAdClick()
                })
            }
        }

        // 广告主头像
        adProviderBean.iconId?.let { iconId ->
            adProviderBean.layout.findViewById<FrameLayout>(iconId)?.apply {
                removeAllViews()
                val imageView = ImageView(context)
                imageView.scaleType = ImageView.ScaleType.FIT_CENTER
                if (TextUtils.isEmpty(getAdPlans()?.advertiserAvatarPath)) {
                    Glide.with(context).load(getAdPlans()?.advertiserAvatar).fitCenter()
                        .into(imageView)
                } else {
                    Glide.with(context).load(getAdPlans()?.advertiserAvatarPath).fitCenter()
                        .into(imageView)
                }
                // 全屏展示
                addView(imageView)
            }
        }

        // 高斯模糊背景
        if (getAdMaterialList()?.type == AdMaterialList.NON_AD_TYPE_TEXT) {
            adProviderBean.burlBgId?.let { mediaId ->
                val imageViewBlur = adProviderBean.layout.findViewById<ImageView>(mediaId)
                imageViewBlur.scaleType = ImageView.ScaleType.CENTER_CROP
                // 如果本地地址是空的，那就不使用线上地址在线加载
                val path = if (TextUtils.isEmpty(getAdMaterialList()?.image?.path)) {
                    getAdMaterialList()?.image?.url
                } else {
                    getAdMaterialList()?.image?.path
                }
                Glide.with(context).load(path).transform(BlurTransformation(25)).into(imageViewBlur)
            }
        }

        // AD 标识控制
        adProviderBean.adTagId?.let { adTagId ->
            adProviderBean.layout.findViewById<AdTagView>(adTagId)?.apply {
                AdTagManager.handleForAdTagView(this)
            }
        }

        // 展示媒体内容
        showMedia()

        // 组装View 将广告布局添加到容器中
        removeAllViews()
        addView(
            adProviderBean.layout, LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT
            )
        )
    }

}