package com.transsion.ad.bidding

import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdNativeInfo
import com.hisavana.common.interfacz.TAdditionalListener
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.icon.BiddingWrapperIconBean
import com.transsion.ad.ps.model.RecommendInfo

/**
 * @author shmizhangxinbing
 * @date : 2025/5/28 15:44
 * @description: 新版本回调
 */
abstract class BiddingTAdditionalListener : TAdditionalListener() {

    /**
     * 竞价结果回调
     */
    open fun onBiddingError(p0: TAdErrorCode?) {}
    open fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {}
    open fun onBiddingLoad(maxEcpmObject: List<BiddingIntermediateMaterialBean>?) {}

    /**
     * Wrapper 广告事件回调
     *
     * Hi程序化广告回调和包断广告回调整合回调给场景
     *
     * 2025-09-19 修改参数
     */
    open fun onBiddingWrapperAdDisplay(maxEcpmObject: BiddingIntermediateMaterialBean?) {}
    open fun onBiddingWrapperAdClick(maxEcpmObject: BiddingIntermediateMaterialBean?) {}
    open fun onBiddingWrapperAdClose(maxEcpmObject: BiddingIntermediateMaterialBean?) {}
    open fun onBiddingWrapperAdRewarded(maxEcpmObject: BiddingIntermediateMaterialBean?) {}
    open fun onBiddingWrapperAdShowError(maxEcpmObject: BiddingIntermediateMaterialBean?) {}

    /**
     * 包断广告回调
     *
     * 2025-09-22 修改参数
     */
    open fun onBiddingBuyOutDisplay(maxEcpmObject: BiddingIntermediateMaterialBean?) {} // 曝光
    open fun onBiddingBuyOutDisplayTimestamp(maxEcpmObject: BiddingIntermediateMaterialBean?, displayTimestamp: Long) {} // 展示时间上报
    open fun onBiddingBuyOutClick(maxEcpmObject: BiddingIntermediateMaterialBean?) {} // 点击
    open fun onBiddingBuyOutError(p0: TAdErrorCode?, maxEcpmObject: BiddingIntermediateMaterialBean?) {} // 加载展示错误
    open fun onBiddingBuyOutShowError(p0: TAdErrorCode?, maxEcpmObject: BiddingIntermediateMaterialBean?) {} // 加载展示错误
    open fun onBiddingBuyOutClose(maxEcpmObject: BiddingIntermediateMaterialBean?) {} // 广告页面关闭
    open fun onBiddingBuyOutRewarded(maxEcpmObject: BiddingIntermediateMaterialBean?) {}  // 获取激励
    open fun onBiddingBuyOutResume(maxEcpmObject: BiddingIntermediateMaterialBean?) {}  // 重新进入屏幕就回调

    /**
     * Icon广告相关回调
     */
    open fun onPSDistributionReady(data: MutableList<RecommendInfo>?) {}
    open fun onHiIconAdReady(tAdNativeInfos: MutableList<TAdNativeInfo>) {}
    open fun onMbIconShow(info: RecommendInfo?) {}
    open fun onMbIconShowError(info: RecommendInfo?) {}
    open fun onMbIconClick(info: RecommendInfo?) {}
    open fun onMbIconDisplayTimestamp(info: RecommendInfo?, displayTimestamp: Long) {} // 展示时间上报
    open fun onWrapperIconReady(data: MutableList<BiddingWrapperIconBean>?) {}
}