package com.transsion.ad.bidding.icon

import androidx.annotation.Keep
import com.hisavana.common.bean.TAdNativeInfo
import com.transsion.ad.ps.model.RecommendInfo
import java.io.Serializable

/**
 * @author shmizhangxinbing
 * @date : 2025/8/20 20:50
 * @description: 将两个接口的数据类型保存在一个对象中
 */
@Keep
data class BiddingWrapperIconBean(
    var type: Int,                                  // 类型
    var recommendInfo: RecommendInfo?,              // PS 广告详情
    var nativeInfo: TAdNativeInfo?,                 // HiSavana 广告详情
    var ecpm: Double = 0.0,
    var isDisplay: Boolean = false                  // 是否已经曝光过了
) : Serializable {
    companion object {
        const val WRAPPER_ICON_ITEM_PS = 1
        const val WRAPPER_ICON_ITEM_HI = 2
    }
}