package com.transsion.ad.bidding.icon

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.FrameLayout
import com.hisavana.mediation.ad.TAdNativeView
import com.hisavana.mediation.ad.TIconView
import com.transsion.ad.bidding.base.AbsBiddingAdLayoutProvider
import com.transsion.ad.util.ViewUtil
import com.transsion.ad.view.native_ad.BiddingIconView

/**
 * @author shmizhangxinbing
 * @date : 2025/8/21 11:16
 * @description: Icon 展示，支持解析 PS+Hi程序化
 */
class BiddingWrapperIconView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null
) : FrameLayout(context, attrs) {

    private var biddingIconView: BiddingIconView? = null    // 包断广告View
    private var tAdNativeView: TAdNativeView? = null    // Hi程序化View


    // =============================================================================================


    /**
     * 资源回收
     */
    fun destroy() {
        biddingIconView?.destroy()
        tAdNativeView?.release()
    }

    /**
     * 模拟点击
     */
    fun onClick(
        data: BiddingWrapperIconBean?,
        viewBinder: AbsBiddingAdLayoutProvider?
    ) {
        when (data?.type) {
            BiddingWrapperIconBean.WRAPPER_ICON_ITEM_PS -> {
                biddingIconView?.iconPerformClick()
            }
            BiddingWrapperIconBean.WRAPPER_ICON_ITEM_HI -> {
                tAdNativeView?.findViewById<TIconView>(viewBinder?.getIconId() ?: 0)?.performClick()
            }
        }
    }

    /**
     * 展示数据
     */
    fun showData(
        adManager: BiddingIconAdManager?,
        data: BiddingWrapperIconBean,
        absAdLayoutProvider: AbsBiddingAdLayoutProvider?
    ) {

        // 数据需要主动调用回收
        adManager?.addBiddingWrapperIconView(this@BiddingWrapperIconView)

        if (data.type == BiddingWrapperIconBean.WRAPPER_ICON_ITEM_PS) {
            biddingIconView?.destroy()
            ViewUtil.removeSelfFromParent(biddingIconView)
            biddingIconView = BiddingIconView(context)
            if (data.isDisplay) {
                biddingIconView?.isReportAdDisplay(true)
            }
            biddingIconView?.setSceneId(adManager?.getSceneId())    // 场景ID
            biddingIconView?.setListener(adManager?.getListener())  // 曝光点击事件回传给 BiddingIconAdManager 统一处理
            biddingIconView?.setRecommendInfo(data.recommendInfo)   // PS 兜底Offer 数据
            biddingIconView?.bindIconView(absAdLayoutProvider)      // 绑定View

            tAdNativeView?.visibility = View.GONE
            biddingIconView?.visibility = View.VISIBLE
            addView(biddingIconView)
        } else if (data.type == BiddingWrapperIconBean.WRAPPER_ICON_ITEM_HI) {
            tAdNativeView?.release()
            ViewUtil.removeSelfFromParent(tAdNativeView)
            tAdNativeView = TAdNativeView(context)
            tAdNativeView?.let { nativeView ->
                data.nativeInfo?.let { nativeInfo ->
                    absAdLayoutProvider?.getHiViewBinder(
                        absAdLayoutProvider.getAdLayoutProvider(), nativeInfo
                    )?.let { viewBinder ->
                        adManager?.getNativeAd()?.bindNativeView(nativeView, nativeInfo, viewBinder)
                    }
                }
            }

            biddingIconView?.visibility = View.GONE
            tAdNativeView?.visibility = View.VISIBLE
            addView(tAdNativeView)
        }
    }

}