package com.transsion.ad.db.mcc

import android.os.Parcelable
import androidx.annotation.Keep
import androidx.room.Entity
import androidx.room.PrimaryKey
import kotlinx.parcelize.Parcelize

/**
 * @author: zhangxinbing
 * @date : 2024/1/2 16:44
 * @description:
 */
@Parcelize
@Keep
@Entity(tableName = "local_mcc")
data class LocalMcc(
    // 主键ID自增
    @PrimaryKey(autoGenerate = true) var id: Int = 0,
    var Country: String,        // 这个字段表示国家的名称
    var Mcc: String,            // 代表“Mobile Country Code”，这是用于移动通讯的国家代码。
    var Iso: String,            // 这是国际标准化组织（ISO）为国家分配的两位字母代码。
    var CountryCode: String,    // 这个字段通常指的是国际拨号代码。
) : Parcelable