package com.transsion.ad.monopoly.intercept

import android.text.TextUtils
import com.blankj.utilcode.util.GsonUtils
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse
import com.transsion.ad.strategy.AdContextManager
import com.transsion.ad.monopoly.model.CtxAttributeConfig
import org.mvel2.MVEL

/**
 * @author: zhangxinbing
 * @date : 2024/8/26 17:57
 * @description:
 */
internal abstract class BaseAdSceneCtxExprHandler : AbsAdPlanInterceptHandler() {

    /**
     * 获取 黑白名单 表达式
     */
    abstract fun getCtxExprString(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): String?

    /**
     * 未命中的时候输出的日志
     */
    abstract fun getMissMsg(): String

    /**
     * 命中的时候输出的日志
     */
    abstract fun getHitMsg(): String

    /**
     * 是否继续下一步
     */
    abstract fun goNext(enable: Boolean): Boolean


    // =============================================================================================


    override suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {

        // 如果上下文参数是空的直接返回,不做上下文检验
        if (ctxMap.isEmpty()) {
            return getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        }

        // 表达式全量字段，如果为空的话直接返回true不做校验
        val ctxAttributeConfig =
            GsonUtils.fromJson(plans?.ctxAttributeConfig, CtxAttributeConfig::class.java)
                ?: return getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()

        // 如果黑名单为空，那就直接返回true
        val ctxExprString = getCtxExprString(sceneId, plans, ctxMap)
        if (TextUtils.isEmpty(ctxExprString)) {
            return getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        }

        // 表达式请求的参数
        val mapRequest = mutableMapOf<String, Any>()
        // 全部添加进去，默认是空字符串。
        ctxAttributeConfig.attrs?.forEach { attr ->
            mapRequest[attr] = ""
        }

        // genre 处理：因为一部作品可能有多个genre
        var genre = ctxMap[AdContextManager.AD_PLANS_SUBJECT_TYPE_GENRE] as? String
        //val genre = "Action, yoruba, Short, Adventure, Erotic"
        //val genre = "Erotic"
        // genre 不为空切里面有","号,那就是多类型的
        val enable =
            if (TextUtils.isEmpty(genre).not() && (genre?.contains(", ") == true || genre?.contains(
                    ","
                ) == true)
            ) {
                genre = genre.replace(" ", "")
                val split = genre.split(",")
                var resultList = false // 多个条件判断，只要有一个是true就是true
                split.forEach {
                    // 然后在使用传进来的进行覆盖
                    mapRequest.putAll(ctxMap)
                    mapRequest[AdContextManager.AD_PLANS_SUBJECT_TYPE_GENRE] = it
                    // 计算表达式
                    if (MVEL.eval(ctxExprString, mapRequest) as Boolean) {
                        resultList = true
                    }
                }
                resultList
            } else {
                // 然后在使用传进来的进行覆盖 --
                mapRequest.putAll(ctxMap)
                // 进行表达式判断
                // [MovieFragment --> ctxMap = {channelId=7, classify=All, country=All, genre=All, tag=All, sort=ForYou}]
                // 计算表达式
                MVEL.eval(ctxExprString, mapRequest) as Boolean
            }

        // 命中黑名单表示当前广告计划不满足展示条件返回false
        // 命中白名单表示当前广告计划满足展示条件返回true
        return if (goNext(enable)) {
            getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        } else {
            AdPlansHitResponse(
                isHit = false, rejectMsg = if (enable) {
                    getHitMsg()
                } else {
                    getMissMsg()
                }
            )
        }
    }

}