package com.transsion.ad.monopoly.intercept

import com.blankj.utilcode.util.GsonUtils
import com.tn.lib.util.device.TNDeviceHelper
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse

/**
 * @author: zhangxinbing
 * @date : 2024/3/18 20:50
 * @description: 机型判断 是否在黑名单中  如果null都展示
 */
internal class InDenyModelHandler : AbsAdPlanInterceptHandler() {

    override suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {

        // 当前设备品牌是否在黑名单中
        var isInDenyModel = false

        // 机型黑名单判断
        val currentModel = TNDeviceHelper.getModel()
        val denyModel = plans?.denyModel
        val denyModelFromJson = GsonUtils.fromJson(denyModel, Array<String>::class.java)
        if (denyModelFromJson.isNullOrEmpty()) {
            isInDenyModel = false
        } else {
            denyModelFromJson.forEach {
                // 这里匹配规则需要包含
                if (it.lowercase().contains(currentModel.lowercase()) || currentModel.lowercase()
                        .contains(it.lowercase())
                ) {
                    isInDenyModel = true
                }
            }
        }

        // 当前条件通过继续下一个条件判断 -- 否则直接返回失败
        return if (isInDenyModel.not()) {
            getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        } else {
            AdPlansHitResponse(isHit = false, rejectMsg = "当前手机机型在黑名单中")
        }
    }
}