package com.transsion.ad.test

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.cloud.hisavana.sdk.api.view.AdChoicesView
import com.cloud.hisavana.sdk.api.view.AdCloseView
import com.cloud.hisavana.sdk.api.view.MediaView
import com.cloud.hisavana.sdk.api.view.StoreMarkView
import com.transsion.ad.databinding.TestSspHiNativeAdLayoutBinding
import com.transsion.ad.bidding.base.AbsBiddingHiSspAdLayoutProvider

/**
 * @author connor
 * @date : 2025/9/5
 * @description: 搜索页电商广告 Native 布局
 */
class TestSspHotBiddingHiNativeSspAdLayout(context: Context) : AbsBiddingHiSspAdLayoutProvider(context) {

    private val binding = TestSspHiNativeAdLayoutBinding.inflate(
        LayoutInflater.from(context), null, false
    )

    override val rootView: View get() = binding.root

    override val mediaView: MediaView get() = binding.nativeAdMedia

    override val iconView: ImageView get() = binding.nativeAdIcon

    override val titleView: TextView? get() = binding.nativeAdTitle

    override val descriptionView: TextView? get() = binding.nativeAdDes

    override val callToActionView: TextView? get() = binding.nativeAdAction

    override val adChoiceView: AdChoicesView? get() = null

    override val adCloseView: AdCloseView? get() = null

    override val psMarkView: StoreMarkView? get() = null
}