package com.transsion.ad.view

import android.content.Context
import android.graphics.Outline
import android.util.AttributeSet
import android.view.View
import android.view.ViewOutlineProvider
import android.widget.FrameLayout
import androidx.core.content.withStyledAttributes
import com.transsion.ad.R

/**
 * @author shmizhangxinbing
 * @date : 2025/8/28 10:48
 * @description:
 *
 * 如果你需要一个高性能、可以设置圆角的 ViewGroup，
 * 推荐使用原生的 FrameLayout（或其他布局），并结合 ViewOutlineProvider 和 clipToOutline 属性来实现圆角。
 * 这样做性能很高，而且代码简单。
 *
 * 使用 clipToOutline 和 ViewOutlineProvider 是目前 Android 原生的高性能圆角方案（适用于 API 21+）。
 * 如果需要兼容更低版本，可以考虑用 Canvas 裁剪，但性能略低。
 * 你可以继承其它 ViewGroup，比如 LinearLayout，只需调整构造函数即可。
 */
class RoundedCornerLayout @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr) {

    var cornerRadius: Float = 0f
        set(value) {
            field = value
            outlineProvider = RoundedOutlineProvider(value)
            clipToOutline = value > 0
        }

    init {
        context.withStyledAttributes(attrs, R.styleable.RoundedCornerLayout) {
            cornerRadius = getDimension(R.styleable.RoundedCornerLayout_cornerRadius, 0f)
        }
        outlineProvider = RoundedOutlineProvider(cornerRadius)
        clipToOutline = cornerRadius > 0
    }

    private class RoundedOutlineProvider(private val radius: Float) : ViewOutlineProvider() {
        override fun getOutline(view: View, outline: Outline) {
            outline.setRoundRect(0, 0, view.width, view.height, radius)
        }
    }
}
