package com.transsion.ad.config

import com.transsion.ad.strategy.AdMmkv

/**
 * @author shmizhangxinbing
 * @date : 2025/6/19 16:09
 * @description: 测试配置
 */
object TestConfig {

    /**
     * 测试广告加载失败
     */
    fun isGlobalAdOff(): Boolean = AdMmkv.getAdMMKV().getBoolean("isGlobalAdOff", false)

    fun setGlobalAdOff(isGlobalAdOff: Boolean) {
        AdMmkv.getAdMMKV().putBoolean("isGlobalAdOff", isGlobalAdOff)
    }


    /**
     * PS 直连接口 生产环境 ===========================================================================
     *
     * 默认生产环境
     */
    fun isReleasePsApi(): Boolean = AdMmkv.getAdMMKV().getBoolean("isReleasePsApi", true)

    fun setReleasePsApi(isRelease: Boolean) {
        AdMmkv.getAdMMKV().putBoolean("isReleasePsApi", isRelease)
    }


    /**
     * 未命中的广告计划 输出日志 =======================================================================
     */
    private var isHitLog: Boolean? = null

    fun isNonHitLog(): Boolean? {
        if (isHitLog == null) {
            isHitLog = AdMmkv.getAdMMKV().getBoolean("isHitLog", false)
        }
        return isHitLog
    }

    fun setNonHitLog(hitLog: Boolean?) {
        if (hitLog == null) {
            return
        }
        AdMmkv.getAdMMKV().putBoolean("isHitLog", hitLog)
        isHitLog = hitLog
    }
}