package com.transsion.ad.db.pslink

import android.os.Parcelable
import androidx.annotation.Keep
import androidx.room.Entity
import androidx.room.PrimaryKey
import kotlinx.parcelize.Parcelize

/**
 * @author: liupeng
 * @date : 2024/7/29 14:12
 * @description: 广告计划数据库操作
 *
 * */
@Parcelize
@Keep
@Entity(tableName = "ps_link_ad")
data class PsLinkAdPlan(
    //场景+psItem Id
    @PrimaryKey var id: Int,
    // 包断计划ID
    var nonId: String,
    //广告类型是ps
    var adSource: String,
    //场景名称 = ps场景id = ps广告位id
    var extAdSlot: String,
    //按插入顺序 排序
    var rank: Int = 0,
    //ps appid 用于识别app信息是否要更新
    var psPlanId: String? = null,
    //ps商单转化信息
    var psLinkAdInfoStr: String? = null,
    //ps商单信息
    var psInfoJson: String? = null,

    // 更新时间戳，默认当前时间
    // 根据时间戳获取列表里面的一个数据
    var updateTimestamp: Long? = null,

    // 2025-08-15 PS Offer 拉活 控频需求
    var showMax: Int? = null,          // 展示数量上限, 0不限制（默认）
    var clickMax: Int? = null,         // 点击数量上限, 0不限制（默认）
    var showHours: String? = null,     // 物料展示时段：0-23, 如：0,1,2,3,10，新数据必有值，历史数据为null 0代表（0点-1点时间段）；23代表（23点-24点时间段）
    var showedTimes: Int = 0,          // 已经展示数量
    var clickedTimes: Int = 0,         // 已经点击数量
    var showDate: String? = null,      // 展示日期

) : Parcelable