package com.transsion.ad.monopoly.intercept

import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse

/**
 * @author: zhangxinbing
 * @date : 2024/3/18 20:23
 * @description: 自定义 广告计划拦截器
 */
internal abstract class AbsAdPlanInterceptHandler {

    protected fun getClassTag(): String = javaClass.simpleName

    private var chain: AbsAdPlanInterceptHandler? = null

    private fun next(absInterceptHandler: AbsAdPlanInterceptHandler?) {
        chain = absInterceptHandler
    }

    fun getChain(): AbsAdPlanInterceptHandler? = chain

    abstract suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse

    protected fun logErrorMsg(msg: String) {
        //AdLogger.logSdkE("${getClassTag()} --> $msg")
    }

    /**
     * 默认值
     *
     * 默认广告计划不可用
     */
    protected fun getDefaultRes(): AdPlansHitResponse =
        AdPlansHitResponse(isHit = true, rejectMsg = "default")


    // =============================================================================================


    /**
     * 建造者
     */
    class Builder {
        /***首*/
        private var head: AbsAdPlanInterceptHandler? = null

        /***尾*/
        private var tail: AbsAdPlanInterceptHandler? = null

        fun addHandler(absInterceptHandler: AbsAdPlanInterceptHandler?): Builder {
            if (head == null) {
                tail = absInterceptHandler
                head = tail
                return this
            }
            tail?.next(absInterceptHandler)
            tail = absInterceptHandler
            return this
        }

        fun build(): AbsAdPlanInterceptHandler? {
            return head
        }
    }

}