package com.transsion.ad.strategy

import com.transsion.ad.R

/**
 * @author shmizhangxinbing
 * @date : 2025/8/29 10:57
 * @description: 打开广告页面Activity的交互样式
 */
object AdOverridePendingTransitionManager {

    enum class AdOverridePendingTransitionEnum {
        OVERRIDE_PENDING_TRANSITION_1, // 从屏幕顶部滑下来
    }

    fun getTransition(overridePendingTransition: AdOverridePendingTransitionEnum? = null): Pair<Int, Int>? {
        return when (overridePendingTransition) {
            AdOverridePendingTransitionEnum.OVERRIDE_PENDING_TRANSITION_1 -> {
                Pair(R.anim.slide_in_from_top, R.anim.no_anim)
            }

            null -> null
        }
    }

}