package com.transsion.ad.util

import com.transsion.ad.log.AdLogger
import java.io.File

/**
 * @author: zhangxinbing
 * @date : 2025/2/14 11:39
 * @description:
 */
internal object FileUtil {

    /**
     * 如果目标文件夹不存在，则创建目标文件夹
     *
     * val directoryPath = "your_directory_path"
     * createDirectoryIfNotExists(directoryPath)
     */
    fun createDirectoryIfNotExists(directoryPath: String) {
        val directory = File(directoryPath)
        if (!directory.exists()) {
            directory.mkdirs()
        }
        AdLogger.logAdInit("${javaClass.simpleName} --> createDirectoryIfNotExists() --> 目标文件夹 创建成功 --> directoryPath = $directoryPath")
    }

    /**
     * 通过路径判断文件是否存在
     */
    fun isFileExists(filePath: String): Boolean {
        val file = File(filePath)
        return file.exists()
    }

    /**
     * 删除过期资源
     *
     * 删除指定文件中未选中文件
     */
    fun deleteFile(file: File, set: HashSet<String?>) {
        if (file.isDirectory) {
            val listFiles = file.listFiles()
            listFiles?.let {
                if (listFiles.isNotEmpty()) {
                    listFiles.forEach {
                        if (it.isDirectory) {
                            deleteFile(it, set)
                        } else if (it.isFile && set.contains(it.path).not()) {
                            // 如果是文件并且不在最新的计划里面，就删除资源
                            it.delete()
                        }
                    }
                }
            }

        }
    }

    /**
     * 要将字节转换为兆字节（MB），您可以将字节除以1024的平方。
     * // 使用示例
     * val bytes = 1024 * 1024 * 10 // 10 MB
     * val megabytes = convertBytesToMegabytes(bytes)
     * println("字节转换为兆字节：$megabytes MB")
     */
    fun convertBytesToMegabytes(bytes: Long): Double {
        return bytes.toDouble() / (1024 * 1024)
    }

    /**
     * 删除文件夹
     * @param folderPath String
     * @param retainDir String?  //要保留的目录
     */
    fun clearFolder(folderPath: String, retainDir: String? = null) {
        val folder = File(folderPath)
        if (folder.exists() && folder.isDirectory) {
            val files = folder.listFiles()
            if (files != null) {
                for (file in files) {
                    if (file.isFile) {
                        file.delete()
                    } else if (file.isDirectory) {
                        if (retainDir != null && file.path.endsWith(retainDir, true)) {
                            //
                            continue
                        } else {
                            clearFolder(file.path, retainDir)
                        }
                    }
                }
            }
        }
    }

    /**
     * 获取文件最近使用的时间戳
     * @return lastModified()方法返回的时间戳是以毫秒为单位的
     */
    fun getFileLastModifiedTime(filePath: String): Long {
        val file = File(filePath)
        return file.lastModified()
    }

    /**
     * 遍历文件夹下的所有文件判断文件是否存在
     * // 使用示例
     * val directoryPath = "/path/to/directory"
     * checkFilesExistence(directoryPath)
     */
    fun checkFilesExistence(directoryPath: String): Boolean {
        val directory = File(directoryPath)
        if (directory.isDirectory) {
            val files = directory.listFiles()
            if (files != null) {
                for (file in files) {
                    if (file.isFile) {
                        // val filePath = file.absolutePath
                        // println("文件路径：$filePath，存在状态：$exists")
                        return file.exists()
                    }
                }
            }
        }
        return false
    }

    /**
     * 获取文件夹的大小
     * // 使用示例
     * val folderPath = "/path/to/folder"
     * val size = getFolderSize(folderPath)
     * println("文件夹大小：$size 字节")
     */
    fun getFolderSize(folderPath: String): Long {
        val folder = File(folderPath)
        var size: Long = 0

        if (folder.isDirectory) {
            val files = folder.listFiles()
            if (files != null) {
                for (file in files) {
                    if (file.isFile) {
                        size += file.length()
                    } else if (file.isDirectory) {
                        size += getFolderSize(file.absolutePath)
                    }
                }
            }
        }
        return size
    }

}