package com.transsion.ad.util

import android.annotation.SuppressLint
import android.app.KeyguardManager
import android.content.Context
import android.os.Build
import android.os.PowerManager

/**
 * @author shmizhangxinbing
 * @date : 2025/9/9 14:42
 * @description:
 */
object ScreenUtils {

    /**
     * 判断当前设备屏幕是否关闭
     *
     * 1. isScreenOn 是较早的 API
     *      true：屏幕是关闭的。
     *      false：屏幕是开启的。
     * 2. 适用于 Android 5.0（API 21）及以上版本。
     *      true：屏幕是关闭的。
     *      false：屏幕是开启的。
     */
    @SuppressLint("ObsoleteSdkInt")
    fun isScreenActive(context: Context): Boolean {
        val powerManager = context.getSystemService(Context.POWER_SERVICE) as PowerManager
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT_WATCH) {
            powerManager.isInteractive
        } else {
            @Suppress("DEPRECATION") powerManager.isScreenOn
        }
    }

    /**
     * 判断设备当前是否处于锁屏状态
     *
     * 1. 判断 Android 版本：
     *      如果版本≥Android 6.0（API 23），使用 isDeviceLocked 或 isKeyguardLocked：
     *          isDeviceLocked：判断设备是否被锁定（如密码、指纹等未解锁）。
     *          isKeyguardLocked：判断是否有锁屏界面显示（可能只是锁屏界面）。
     *      如果版本低于 Android 6.0，只能用 isKeyguardLocked。
     * 2. 返回锁定状态。
     *      true：设备当前处于锁屏状态。
     *      false：设备已经解锁或没有锁屏界面。
     */
    fun isScreenLocked(context: Context): Boolean {
        val keyguardManager = context.getSystemService(Context.KEYGUARD_SERVICE) as KeyguardManager
        val isLocked = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            keyguardManager.isDeviceLocked || keyguardManager.isKeyguardLocked
        } else {
            keyguardManager.isKeyguardLocked
        }
        return isLocked
    }
}