package com.transsion.ad.view

import android.content.Context
import android.graphics.LinearGradient
import android.graphics.Shader
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatTextView
import androidx.core.content.ContextCompat
import com.transsion.ad.R

/**
 * @author: zhangxinbing
 * @date : 2025/3/24 20:17
 * @description: 支持设置渐变色
 */
open class GradientTextView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : AppCompatTextView(context, attrs, defStyleAttr) {

    private var startColor: Int = ContextCompat.getColor(context, R.color.ad_white_6)
    private var endColor: Int = ContextCompat.getColor(context, R.color.ad_bg_01)


    // =============================================================================================


    init {
        attrs?.let {
            val typedArray = context.obtainStyledAttributes(it, R.styleable.GradientTextView)
            startColor = typedArray.getColor(
                R.styleable.GradientTextView_startColor, startColor
            )
            endColor = typedArray.getColor(
                R.styleable.GradientTextView_endColor, endColor
            )
            typedArray.recycle()
        }
        updateShader()
    }

    override fun onLayout(changed: Boolean, left: Int, top: Int, right: Int, bottom: Int) {
        super.onLayout(changed, left, top, right, bottom)
        if (changed) {
            updateShader() // 更新 Shader
        }
    }


    // =============================================================================================


    /**
     * 设置渐变色
     */
    fun setGradientColors(startColor: Int, endColor: Int) {
        this.startColor = startColor
        this.endColor = endColor
        updateShader() // 更新 Shader
    }

    /**
     * 更新 Shader
     */
    private fun updateShader() {
        val shader = LinearGradient(
            0f, 0f, width.toFloat(), 0f, // 渐变方向：从左到右
            intArrayOf(startColor, endColor, endColor), // 颜色数组
            null, // 颜色分布位置（null 表示均匀分布）
            Shader.TileMode.CLAMP // 渐变模式
        )
        paint.shader = shader
        invalidate() // 强制重绘
    }
}