package com.transsion.ad.bidding.nativead

import android.text.TextUtils
import com.cloud.hisavana.sdk.api.listener.AdListener
import com.cloud.hisavana.sdk.api.view.TNativeView
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo
import com.hisavana.mediation.ad.TAdNativeView
import com.transsion.ad.bidding.base.AbsAdBidding
import com.transsion.ad.bidding.gemini.AbsBiddingBuyOutGemini
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.monopoly.plan.AdPlanSourceManager
import com.transsion.ad.monopoly.plan.AdPlanUtil
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.strategy.AdContextManager
import com.transsion.ad.view.native_ad.BiddingBuyOutNativeView

/**
 * @author shmizhangxinbing
 * @date : 2025/5/27 19:03
 * @description: 竞价的Native广告
 */
class BiddingNativeManager : AbsAdBidding() {


    companion object {
        /**
         * 预加载
         */
        fun preload(sceneId: String) {
            BiddingHiSspNativeProvider.getNativeManager(sceneId = sceneId)
                ?.preLoadAd(sceneId, reqCount = SceneCommonConfig.getFillAmount(sceneId = sceneId))
        }
    }


    // ==================================== 展示广告的View也需要释放 ===================================


    private var hiNativeViewSet: MutableSet<TAdNativeView?> = mutableSetOf() // Hi聚合NativeView
    private var hiSspNativeViewSet: MutableSet<TNativeView?> = mutableSetOf() // Hi SSP NativeView
    private var buyoutNativeViewSet: MutableSet<BiddingBuyOutNativeView?> =
        mutableSetOf() // 包断广告NativeView

    /*** 一次获取多个广告，临时保存*/
    private var maxEcpmObjectList: MutableList<BiddingIntermediateMaterialBean> = mutableListOf()

    /**
     * 是否必须足数
     */
    private var fetchInFull: Boolean = false

    /**
     * SSP Native广告 回调
     */
    private val sspListener = object : AdListener() {

        override fun onNativeAdShow(p0: TaNativeInfo?) {
            super.onNativeAdShow(p0)
            val maxEcpmObject = maxEcpmObjectList.find {
                it.sspNativeInfo?.uuid == p0?.uuid
            }
            // 也有可能是其他场景的回调过来的，所以要先判断一下是否是自己场景的广告回调
            if (maxEcpmObject != null) {
                // 埋点
                AdReportProvider.display(
                    triggerId = getTriggerId(),
                    sceneId = getSceneId(),
                    adPlanId = maxEcpmObject.plans?.id,
                    adSource = 0, // 0 SSP
                    adId = p0?.adItem?.codeSeatId,
                    adType = getAdType(),
                    isAdShowFinal = false,
                    //psId = null,
                    psRecommendInfo = AdPlanUtil.getPsRecommendInfo(maxEcpmObject.plans),
                    bidEcpmCent = maxEcpmObject.ecpm,
                    ecpmCent = null,
                    sceneSubId = getSceneSubId()
                )
                // 通知场景
                onBiddingWrapperAdDisplay(maxEcpmObject)
            }
        }

        override fun onNativeAdClick(p0: TaNativeInfo?) {
            super.onNativeAdClick(p0)
            val maxEcpmObject = maxEcpmObjectList.find {
                it.sspNativeInfo?.uuid == p0?.uuid
            }
            if (maxEcpmObject != null) {
                // 埋点
                AdReportProvider.adClick(
                    triggerId = getTriggerId(),
                    sceneId = getSceneId(),
                    adPlanId = maxEcpmObject.plans?.id,
                    adSource = 0, // 0 SSP
                    adId = p0?.adItem?.codeSeatId,
                    adType = getAdType(),
                    isAdShowFinal = false,
                    //psId = null,
                    psRecommendInfo = AdPlanUtil.getPsRecommendInfo(maxEcpmObject.plans),
                    bidEcpmCent = maxEcpmObject.ecpm,
                    ecpmCent = null,
                    sceneSubId = getSceneSubId()
                )
                // 通知场景
                onBiddingWrapperAdClick(maxEcpmObject)
            }
        }
    }


    // =============================================================================================


    fun addBuyOutNativeView(view: BiddingBuyOutNativeView?) {
        buyoutNativeViewSet.add(view)
    }

    fun addHiNativeView(view: TAdNativeView?) {
        hiNativeViewSet.add(view)
    }

    fun addHiSspNativeView(view: TNativeView?) {
        hiSspNativeViewSet.add(view)
    }

    fun setFetchInFull(inFull: Boolean) {
        fetchInFull = inFull
    }

    fun isReady(): Boolean {
        return getMaxEcpmObject() != null
    }

    fun isHiAd(): Boolean = AdPlanSourceManager.isHiAdPlan(getMaxEcpmObject()?.plans)


    // =============================================================================================


    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_NATIVE

    override fun getGemini(): AbsBiddingBuyOutGemini? = null

    override fun destroy() {
        // 这里时序调用有问题，需要在父类调用之前释放掉，不然会内存泄漏
        // Hi程序化Native回调释放
        BiddingHiSavanaNativeProvider.getNativeManager(getSceneId())?.removeListener(this)
        // Hi程序化SSP Native回调释放
        BiddingHiSspNativeProvider.getNativeManager(getSceneId())?.removeListener(sspListener)
        // nativeInfo 释放
        getMaxEcpmObject()?.nativeInfo?.release()
        maxEcpmObjectList.forEach {
            it.nativeInfo?.release()
        }
        // 广告View释放
        buyoutNativeViewSet.forEach {
            it?.destroy()
        }
        hiNativeViewSet.forEach {
            it?.release()
        }
        hiSspNativeViewSet.forEach {
            it?.destroy()
        }
        super.destroy()
    }

    override fun getLogTag(): String = AdLogger.TAG_AD_NATIVE

    override fun addHiSavanaProvider(
        biddingPlan: MutableList<BiddingIntermediateMaterialBean>,
        adPlans: AdPlans,
        fetchCount: Int, // 请求广告的数量
    ) {
        // 请求数量大于1，且HiSSP的PlacementId不为空时请求广告SSP广告
        // 否则请求包断广告+HI程序化Native广告
        // 目前HI程序化聚合Native不支持一次请求返回多个广告
        if (fetchCount > 1 && TextUtils.isEmpty(SceneCommonConfig.getHiSspPlacementId(getSceneId()))
                .not()
        ) {
            // 加载SSP广告 --> 封装到BiddingIntermediateMaterialBean --> 添加到竞价队列
            // 同步获取SSP广告
            val nativeInfo = BiddingHiSspNativeProvider.getNativeManager(getSceneId())
                ?.getAdsSync(SceneCommonConfig.getFillAmount(getSceneId()), fetchInFull)

            nativeInfo?.forEach {
                if (isUseHiEcpm(adPlans)) {
                    adPlans.bidEcpmCent = it.bidPrice
                }

                // isMatchVulgarBrand == true的话，表示不能在敏感场景下使用
                if (AdContextManager.isDangerGenre(getCtxMap()) && it.isMatchVulgarBrand) {
                    // 无法使用
                } else {
                    biddingPlan.add(
                        BiddingIntermediateMaterialBean(
                            ecpm = adPlans.bidEcpmCent,
                            plans = adPlans,
                            sspNativeInfo = it,
                            isExpend = false
                        )
                    )
                }
            }

            if (nativeInfo?.isNotEmpty() == true) {
                // 添加一个回调
                BiddingHiSspNativeProvider.getNativeManager(getSceneId())?.addListener(sspListener)
            }
        } else {
            // Hi程序化广告需要同步请求,请求到了添加到结果队列
            val nativeInfo =
                BiddingHiSavanaNativeProvider.getNativeManager(getSceneId())?.getAdsSync()

            // isMatchVulgarBrand == true的话，表示不能在敏感场景下使用
            if (AdContextManager.isDangerGenre(getCtxMap()) && nativeInfo?.isMatchVulgarBrand == true) {
                nativeInfo.release() // 无法使用
                return
            }

            // 同步获取到了就添加到竞价队列
            if (nativeInfo != null) {
                if (isUseHiEcpm(adPlans)) {
                    adPlans.bidEcpmCent = nativeInfo.ecpmPrice
                }

                biddingPlan.add(
                    BiddingIntermediateMaterialBean(
                        ecpm = adPlans.bidEcpmCent,
                        plans = adPlans,
                        nativeInfo = nativeInfo,
                        isExpend = false
                    )
                )

                // 添加一个回调
                BiddingHiSavanaNativeProvider.getNativeManager(getSceneId())?.addListener(this)
            }
        }
    }

    override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
        super.onBiddingLoad(maxEcpmObject)
        // 需要将其它未使用的NativeInfo重新添加到缓存池中
        // 将未使用NativeInfo释放
        // 直接释放，因为低价格在后面的竞价还是失败
        getBiddingPlanList()?.forEach {
            if (it.nativeInfo != null && TextUtils.equals(maxEcpmObject?.plans?.id, it.plans?.id)
                    .not()
            ) {
                it.nativeInfo.release()
            }
        }
    }

    override fun onBiddingLoad(maxEcpmObject: List<BiddingIntermediateMaterialBean>?) {
        super.onBiddingLoad(maxEcpmObject)
        // 释放旧的
        maxEcpmObjectList.forEach {
            it.nativeInfo?.release()
        }
        maxEcpmObjectList.clear()

        // 保存新的
        maxEcpmObject?.forEach {
            // 保存所有竞价成功的对象
            maxEcpmObjectList.add(it)
        }
    }
}