package com.transsion.ad.bidding.splash

import android.app.Activity
import android.content.Intent
import android.text.TextUtils
import android.view.View
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.AdditionalInfo
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdRequestBody
import com.hisavana.common.constant.ComConstants
import com.hisavana.mediation.ad.TBaseAd
import com.hisavana.mediation.ad.TSplashAd
import com.hisavana.mediation.ad.TSplashView
import com.transsion.ad.MBAd
import com.transsion.ad.bidding.base.AbsBiddingInterceptHiSavanaAdManager
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.strategy.AdContextManager
import java.lang.ref.WeakReference

/**
 * @author shmizhangxinbing
 * @date : 2025/5/30 10:31
 * @description: Hi程序化开屏广告
 */
class BiddingHiSavanaSplashProvider : AbsBiddingInterceptHiSavanaAdManager() {

    companion object {

        const val KEY_SCENE_ID = "key_scene_id"

        /**
         * 因为所有的HiSavana 广告位ID都是服务端下发的,所以客户端会有多个对象
         */
        private val map by lazy {
            HashMap<String, BiddingHiSavanaSplashProvider>()
        }

        /**
         * 通过广告位ID获取广告加载对象
         */
        fun getManager(sceneId: String?): BiddingHiSavanaSplashProvider? {
            if (TextUtils.isEmpty(sceneId)) {
                return null
            }
            val hisavanaPlacementId =
                SceneCommonConfig.getHiSavanaPlacementId(sceneId) ?: return null
            var manager = map[hisavanaPlacementId]
            if (null == manager) {
                manager = BiddingHiSavanaSplashProvider()
                manager.setPlacementId(hisavanaPlacementId)
                map[hisavanaPlacementId] = manager
            }
            return manager
        }
    }

    private var tSplashAd: TSplashAd? = null
    private var logoLayout: Int? = null

    fun getLogoLayout(): Int? {
        return logoLayout
    }

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_SPLASH

    override fun getLogTag(): String = AdLogger.TAG_AD_SPLASH

    override fun getAdInstance(): TBaseAd<*>? {
        if (null == tSplashAd) {
            tSplashAd = TSplashAd(Utils.getApp(), getPlacementId())
            tSplashAd?.setRequestBody(
                TAdRequestBody.AdRequestBodyBuild().setAdditionalListener(this).build()
            )
            tSplashAd?.setSplashMode(ComConstants.SplashMode.SPLASH_VIEW)
            tSplashAd?.setOnlySourceAdx(MBAd.getAdInitParams()?.hisavanaAppId ?: "",
                MBAd.getAdInitParams()?.isDebug ?: false)
        }
        return tSplashAd
    }

    override fun show(
        topActivity: Activity,
        sceneId: String,
        appLayoutId: Int?,
        ctxMap: Map<String, Any>?
    ) {
        AdLogger.logSdk(
            tag = AdLogger.TAG_AD_SPLASH, msg = "start Hi splash activity --> show"
        )
        logoLayout = appLayoutId
        if (AdContextManager.isDangerGenre(ctxMap)) {
            tSplashAd?.setContainVulgarContent(true)
        }
        kotlin.runCatching {
            topActivity.startActivity(Intent(
                topActivity,
                BiddingHisavanaSplashActivity::class.java
            ).apply {
                putExtra(KEY_SCENE_ID, sceneId)
            })
        }.onFailure {
            AdLogger.logSdk(
                tag = AdLogger.TAG_AD_SPLASH, msg = "程序化开屏 show 异常 --> ${it.message}"
            )
            getListener()?.onShowError(
                TAdErrorCode(-1, "程序化开屏 show 异常 --> ${it.message}"), AdditionalInfo()
            )
        }
    }

    fun showSplashAd(
        activity: BiddingHisavanaSplashActivity,
        splashView: TSplashView?,
        logo: View?
    ) {
        AdLogger.logSdk(
            tag = AdLogger.TAG_AD_SPLASH, msg = "BiddingHisavanaSplashProvider --> showSplashAd"
        )
        val weakActivity = WeakReference(activity)
        weakActivity.get()?.let {
            tSplashAd?.setOnSkipListener(it)
        }

        splashView?.let {
            tSplashAd?.showAd(splashView, logo)
        }
    }

    override fun reset() {
        tSplashAd?.destroy()
        tSplashAd = null
    }
}