package com.transsion.ad.bidding.splash

import android.util.Log
import com.hisavana.common.bean.AdditionalInfo
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdNativeInfo
import com.transsion.ad.bidding.base.AbsAdBidding
import com.transsion.ad.bidding.gemini.AbsBiddingBuyOutGemini
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.gemini.BiddingBuyOutSplashGemini
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author shmizhangxinbing
 * @date : 2025/5/30 10:18
 * @description: 开屏广告加载
 */
class BiddingSplashManager : AbsAdBidding() {

    private val gemini = BiddingBuyOutSplashGemini()
    private var adCallback: ((info: AdditionalInfo?) -> Unit)? = null

    // =================================== BuyOut 广告回调 开屏广告需要特殊处理 =========================

    override fun onBiddingBuyOutClose(maxEcpmObject: BiddingIntermediateMaterialBean?) {
        super.onBiddingBuyOutClose(maxEcpmObject)
        getListener()?.onBiddingBuyOutClose(maxEcpmObject)
        destroy()
    }

    // ====================================== 子类实现逻辑 ===========================================


    override fun getLogTag(): String = AdLogger.TAG_AD_SPLASH

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_SPLASH

    override fun getGemini(): AbsBiddingBuyOutGemini = gemini

    override fun onLoadSuccess(additionalInfo: AdditionalInfo) {
        super.onLoadSuccess(additionalInfo)

        onLog(level = Log.INFO, msg = "onLoadSuccess() --> 开屏广告加载成功 --> ecpm: ${additionalInfo.eCPM}", writeToFile = false)
        adCallback?.invoke(additionalInfo)
    }

    override fun onLoadFailure(
        errorCode: TAdErrorCode?,
        additionalInfo: AdditionalInfo
    ) {
        super.onLoadFailure(errorCode, additionalInfo)
        onLog(level = Log.INFO, msg = "onLoadFailure() --> 开屏广告加载失败", writeToFile = false)
        adCallback?.invoke(null)
    }

    override fun onClick(p0: TAdNativeInfo?, p1: AdditionalInfo) {
        super.onClick(p0, p1)
        onLog(level = Log.INFO, msg = "onClick() --> 开屏广告点击", writeToFile = false)
    }

    override fun onClosed(p0: Int) {
        super.onClosed(p0)
        adCallback = null
        onLog(level = Log.INFO, msg = "onClosed() --> 开屏广告关闭", writeToFile = false)
    }

    override fun addHiSavanaProvider(
        biddingPlan: MutableList<BiddingIntermediateMaterialBean>,
        adPlans: AdPlans,
        fetchCount: Int
    ) {
        val splashProvider = BiddingHiSavanaSplashProvider.getManager(getSceneId())
        splashProvider?.setListener(this)
        splashProvider?.getAdInstance()?.loadAd()

        adCallback = { info ->
            info?.let {
                if (isUseHiEcpm(adPlans)) {
                    adPlans.bidEcpmCent = info.eCPM
                }

                biddingPlan.add(
                    BiddingIntermediateMaterialBean(
                        ecpm = adPlans.bidEcpmCent,
                        plans = adPlans,
                        nativeInfo = null,
                        isExpend = false,
                        hiSavanaInterceptProvider = splashProvider
                    )
                )

                // 程序化开屏加载成功，立即开始竞价
                startBidding()
            }

            adCallback = null
        }

        splashProvider?.enterScene(getSceneId())
    }
}