package com.transsion.ad.config

import com.blankj.utilcode.util.GsonUtils
import com.transsion.ad.strategy.AdMmkv

/**
 * @author: zhangxinbing
 * @date : 2024/4/9 10:14
 * @description: 通过会员的状态判断是否进行广告的展示
 */
internal object MemberBusinessSwitch {

    /**
     * 存 --> 设置数据
     */
    fun setSkipShowAd(isPassed: Boolean) {
        AdMmkv.mmkvWithID.putBoolean(AdMmkv.AD_MMKV_KEY_IS_SKIP_AD, isPassed)
    }

    /**
     * 取 --> 广告内部获取 -- 默认展示广告
     */
    fun isSkipShowAd(): Boolean {
        return AdMmkv.mmkvWithID.getBoolean(AdMmkv.AD_MMKV_KEY_IS_SKIP_AD, false)
    }

    /**
     * 设置会员模式下广告展示白名单
     */
    fun setAdSceneIdWhitList(strings: List<String>) {
        AdMmkv.mmkvWithID.putString(
            AdMmkv.AD_MMKV_KEY_MEMBER_SCENE_ID_WHIT_LIST, GsonUtils.toJson(strings)
        )
    }

    /**
     * 获取会员模式下广告展示白名单
     */
    fun getAdSceneIdWhitList(): List<String> {
        return runCatching {
            val whitListMmkv =
                AdMmkv.mmkvWithID.getString(AdMmkv.AD_MMKV_KEY_MEMBER_SCENE_ID_WHIT_LIST, "")
            val whitList = GsonUtils.fromJson<List<String>>(
                whitListMmkv, GsonUtils.getListType(String::class.java)
            )
            whitList.ifEmpty {
                emptyList()
            }
        }.getOrElse {
            emptyList()
        }
    }

}