package com.transsion.ad.db.pslink

import android.os.Parcelable
import androidx.annotation.Keep
import androidx.room.Entity
import androidx.room.PrimaryKey
import kotlinx.parcelize.Parcelize

/**
 * @author shmizhangxinbing
 * @date : 2025/7/14 15:49
 * @description:
 */
@Parcelize
@Keep
@Entity(tableName = "attribution_points") // 表名：归因埋点
data class AttributionPoint(
    @PrimaryKey(autoGenerate = true) val id: Int = 0, // 主键，任务ID

    val psId: String, // PS Offer 的ID
    var failCount: Int = 0, // 失败次数，默认值为0
    val reportUrl: String, // 上报链接（可直接请求的链接）
    val type: AttributionType, // 类型，使用枚举管理（display、click）
    var updateTimestamp: Long = System.currentTimeMillis() // 更新时间戳，默认当前时间
) : Parcelable {

    enum class AttributionType {
        DISPLAY, // 展示归因
        CLICK, // 点击归因
        GP_CLICK, // GP点击归因
    }

    class TypeConverter {

        // 将枚举转换为字符串存储在数据库中
        @androidx.room.TypeConverter
        fun fromAttributionType(type: AttributionType): String {
            return type.name // 使用枚举的 name 属性（如 "DISPLAY" 或 "CLICK"）
        }

        // 将数据库中的字符串转换回枚举
        @androidx.room.TypeConverter
        fun toAttributionType(value: String): AttributionType {
            return AttributionType.valueOf(value) // 将字符串转换为对应的枚举
        }
    }

}