package com.transsion.ad.monopoly.intercept

import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse

/**
 * @author: zhangxinbing
 * @date : 2024/3/18 20:05
 * @description: 广告场景拦截处理
 */
internal object AdPlanIntercept {

    /**
     * 当前场景 -- 是否命中广告计划
     */
    suspend fun isHit(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {
        // 创建拦截器并且执行,这里做了一层保护，避免因为配置错误导致GsonUtils.fromJson解析异常的问题。
        return kotlin.runCatching {
            val builder = AbsAdPlanInterceptHandler.Builder()
            builder.addHandler(ShowOnNetworkStateHandler())         // 当前计划配置网络状态判断是否展示
                .addHandler(SceneInWhitelistHandler())              // 场景白名单判断
                .addHandler(CountryInWhitelistHandler())            // 国家白名单判断
                .addHandler(InDenyBrandHandler())                   // 手机品牌黑名单判断
                .addHandler(BrandInWhitelistHandler())              // 品牌白名单判断
                .addHandler(InDenyModelHandler())                   // 机型判断是否在黑名单中
                .addHandler(ModelInWhitelistHandler())              // 机型判断是否在白名单中
                .addHandler(ValidTimeHandler())                     // 有效期判断
                .addHandler(ValidDispatchTimeHandler())             // 一天之中分发有效时刻判断
                .addHandler(ValidTimesHandler())                    // 广告展示次数判断
                .addHandler(AdSceneCtxEnableExprHandler())          // 广告展示上下文白名单判断
                .addHandler(AdSceneCtxDisableExprHandler())         // 广告展示上下文黑名单判断
                .addHandler(AdResourceDownloadedHandler())          // 当前广告计划资源是否下载完成
                .build()?.doHandle(sceneId, plans, ctxMap) ?: AdPlansHitResponse(
                isHit = false, rejectMsg = "default"
            )
        }.getOrElse {
            AdPlansHitResponse(isHit = false, rejectMsg = it.message)
        }
    }

}

