package com.transsion.ad.monopoly.model

import androidx.annotation.IntDef

/**
 * @author: zhangxinbing
 * @date : 2024/7/09 16:59
 * @description: 广告来源
 */
@IntDef(
    MbAdSource.MB_AD_SOURCE_MB_TRIGGER,
    MbAdSource.MB_AD_SOURCE_HISAVANA_TRIGGER,
    MbAdSource.MB_AD_SOURCE_BUY_OUT,
    MbAdSource.MB_AD_SOURCE_HISAVANA,
    MbAdSource.MB_AD_SOURCE_NONSTANDARD,
    MbAdSource.MB_AD_SOURCE_BIDDING,
    MbAdSource.MB_AD_SOURCE_WRAPPER_AD,
)
@Retention(AnnotationRetention.SOURCE)
annotation class MbAdSource {
    companion object {
        // 触发埋点使用
        const val MB_AD_SOURCE_MB_TRIGGER = 1
        const val MB_AD_SOURCE_HISAVANA_TRIGGER = 2

        const val MB_AD_SOURCE_WRAPPER_AD = 101   // MB广告SDK
        const val MB_AD_SOURCE_BUY_OUT = 102      // 包断广告 = 1、102、2023      buy out
        const val MB_AD_SOURCE_HISAVANA = 103     // 程序化广告 = 2、103
        const val MB_AD_SOURCE_NONSTANDARD = 104  // 非标广告 = 104
        const val MB_AD_SOURCE_BIDDING = 105 // 竞价
    }
}