package com.transsion.ad.monopoly.plan

import com.blankj.utilcode.util.GsonUtils
import com.google.gson.reflect.TypeToken
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.CtxAttributeConfig
import com.transsion.ad.monopoly.model.MbAdImage

/**
 * @author: zhangxinbing
 * @date : 2023/12/22 10:41
 * @description:广告计划
 */
internal object AdPlansTransform {

    private fun getClassTag(): String = javaClass.simpleName


    // =============================================================================================


    /**
     * 数据库对象 --> 业务对象的转换
     */
    fun transformPlanDb2Bean(mbAdDbPlans: MbAdDbPlans?): AdPlans? {

        if (mbAdDbPlans == null) {
            return null
        }

        return kotlin.runCatching {

            val adPlans = AdPlans(
                id = mbAdDbPlans.id,
                version = mbAdDbPlans.version,
                name = mbAdDbPlans.name,
                advertiserName = mbAdDbPlans.advertiserName,
                advertiserAvatar = mbAdDbPlans.advertiserAvatar,
                advertiserAvatarPath = mbAdDbPlans.advertiserAvatarPath,

                // 展示次数
                displayTimes = mbAdDbPlans.displayTimes,
                showedTimes = mbAdDbPlans.showedTimes,
                showDate = mbAdDbPlans.showDate,

                scenes = GsonUtils.fromJson(mbAdDbPlans.scenes, Array<String>::class.java)
                    ?.toList(),
                country = GsonUtils.fromJson(mbAdDbPlans.country, Array<String>::class.java)
                    ?.toList(),
                brand = GsonUtils.fromJson(mbAdDbPlans.brand, Array<String>::class.java)?.toList(),
                denyBrand = GsonUtils.fromJson(mbAdDbPlans.denyBrand, Array<String>::class.java)
                    ?.toList(),
                model = GsonUtils.fromJson(mbAdDbPlans.model, Array<String>::class.java)?.toList(),
                denyModel = GsonUtils.fromJson(mbAdDbPlans.denyModel, Array<String>::class.java)
                    ?.toList(),

                startTime = mbAdDbPlans.startTime,
                endTime = mbAdDbPlans.endTime,
                extraConfig = mbAdDbPlans.extraConfig,
                adPlanUpdateTime = mbAdDbPlans.adPlanUpdateTime,
                adSource = mbAdDbPlans.adSource,
                extAdSlot = mbAdDbPlans.extAdSlot,
                sort = mbAdDbPlans.sort,

                adShowLevel = mbAdDbPlans.adShowLevel,
                filterClientVersion = mbAdDbPlans.filterClientVersion,
                adPlanCreateTime = mbAdDbPlans.adPlanCreateTime,
                appStarDesc = mbAdDbPlans.appStarDesc,
                appSizeDesc = mbAdDbPlans.appSizeDesc,

                dispatchTimeStart = mbAdDbPlans.dispatchTimeStart,
                dispatchTimeEnd = mbAdDbPlans.dispatchTimeEnd,

                // MovieBox会员&内容广告屏蔽策略
                // https://transsioner.feishu.cn/docx/Pj84dFtm7oSSKnxEezBcOksTnqb
                ctxEnableExpr = mbAdDbPlans.ctxEnableExpr,
                ctxDisableExpr = mbAdDbPlans.ctxDisableExpr,
                ctxAttributeConfig = GsonUtils.fromJson(
                    mbAdDbPlans.ctxAttributeConfig, CtxAttributeConfig::class.java
                ),

                // 素材
                adMaterialList = GsonUtils.fromJson<List<AdMaterialList>>(
                    mbAdDbPlans.adMaterialList, object : TypeToken<List<AdMaterialList>>() {}.type
                ),

                // 首页Banner展示广告计划 扩展图片
                extImage = GsonUtils.fromJson(mbAdDbPlans.extImage, MbAdImage::class.java),

                // 2025-05-28 竞价需求 增加字段 // 竞价价格
                // https://transsioner.feishu.cn/docx/UUGndRUMmok5ODxCdFXcqavEnme
                bidEcpmCent = mbAdDbPlans.bidEcpmCent,
                ecpmCent = mbAdDbPlans.ecpmCent,

                // 当前计划是否有效
                // 2025-08-05
                // https://transsioner.feishu.cn/wiki/LmKMwmS8DieGdJkMDvPczVePnph
                // 修复 广告计划更新及时性导致的展示数量丢失问题处理
                // 0 : false
                // 1 : true
                isValid = mbAdDbPlans.isValid,

                // 是否需要再展示的时候预加载落地页
                h5LinkPreload = mbAdDbPlans.h5LinkPreload,

                // CCT 打开落地页
                h5LinkOpenByCct = mbAdDbPlans.h5LinkOpenByCct
            )

            // TODO  zxb 2025-07-17 PS 虚拟计划单独处理 资源
            //       还是回归最开始的设计，这个类仅处理 对象的转换
            // PS广告计划 素材需要单独处理
            //AdLogger.logSdk("${getClassTag()} --> transformPlanDb2Bean() --> 数据库转业务对象 11 --> adPlans = ${adPlans}")
//            if (AdPlanSourceManager.isPsAdPlan(adPlans)) {
//                PsOfferProvider.parsePsAdPlansMaterialList(adPlans, mbAdDbPlans)
//            }

            // 返回组装好的计划
            adPlans
        }.getOrElse {
            //AdLogger.logSdkE("${getClassTag()} --> transformPlanDb2Bean() --> it = $it")
            null
        }
    }


    // =============================================================================================


    /**
     * 业务对象 --> 数据库对象的转换
     */
    fun transformAdPlans2NonAdPlans(adPlan: AdPlans?): MbAdDbPlans {
        val mbAdDbPlans = MbAdDbPlans(
            id = adPlan?.id ?: "",
            version = adPlan?.version,
            name = adPlan?.name,
            startTime = adPlan?.startTime,
            endTime = adPlan?.endTime,
            extraConfig = adPlan?.extraConfig,
            displayTimes = adPlan?.displayTimes,

            // 优化网络获取的对象覆盖本地已经保存的展示次数 //nonAdPlans.showedTimes = adPlan?.showedTimes
            showedTimes = adPlan?.showedTimes,
            showDate = adPlan?.showDate,
            advertiserName = adPlan?.advertiserName,
            advertiserAvatar = adPlan?.advertiserAvatar,
            advertiserAvatarPath = adPlan?.advertiserAvatarPath,
            brand = GsonUtils.toJson(adPlan?.brand),
            denyBrand = GsonUtils.toJson(adPlan?.denyBrand),
            model = GsonUtils.toJson(adPlan?.model),
            denyModel = GsonUtils.toJson(adPlan?.denyModel),
            country = GsonUtils.toJson(adPlan?.country),
            scenes = GsonUtils.toJson(adPlan?.scenes),
            adPlanUpdateTime = adPlan?.adPlanUpdateTime,
            adSource = adPlan?.adSource,
            extAdSlot = adPlan?.extAdSlot,
            sort = adPlan?.sort,
            adMaterialList = GsonUtils.toJson(adPlan?.adMaterialList),
            adShowLevel = adPlan?.adShowLevel,
            filterClientVersion = adPlan?.filterClientVersion,
            adPlanCreateTime = adPlan?.adPlanCreateTime,
            appStarDesc = adPlan?.appStarDesc,
            appSizeDesc = adPlan?.appSizeDesc,

            dispatchTimeStart = adPlan?.dispatchTimeStart,
            dispatchTimeEnd = adPlan?.dispatchTimeEnd,

            // MovieBox会员&内容广告屏蔽策略 // https://transsioner.feishu.cn/docx/Pj84dFtm7oSSKnxEezBcOksTnqb
            ctxEnableExpr = adPlan?.ctxEnableExpr,
            ctxDisableExpr = adPlan?.ctxDisableExpr,
            ctxAttributeConfig = GsonUtils.toJson(adPlan?.ctxAttributeConfig),

            // 首页Banner展示广告计划 扩展图片
            extImage = GsonUtils.toJson(adPlan?.extImage),

            // 2025-05-28 竞价需求 增加字段 // 竞价价格
            // https://transsioner.feishu.cn/docx/UUGndRUMmok5ODxCdFXcqavEnme
            bidEcpmCent = adPlan?.bidEcpmCent,
            ecpmCent = adPlan?.ecpmCent,

            // 当前计划是否有效
            // 2025-08-05
            // https://transsioner.feishu.cn/wiki/LmKMwmS8DieGdJkMDvPczVePnph
            // 修复 广告计划更新及时性导致的展示数量丢失问题处理
            // 0 : false
            // 1 : true
            isValid = adPlan?.isValid ?: false,
            h5LinkPreload = adPlan?.h5LinkPreload ?: false,

            // CCT 打开落地页
            h5LinkOpenByCct = adPlan?.h5LinkOpenByCct ?: false
        )
        return mbAdDbPlans
    }

}