package com.transsion.ad.scene

import android.text.TextUtils
import com.transsion.ad.config.MemberBusinessSwitch

/**
 * @author: zhangxinbing
 * @date : 2025/2/17 14:50
 * @description: 场景开关
 */
object SceneOnOff {

    /**
     * 下发的字段
     */
    private const val SCENE_CONFIG_KEY_OFF = "sceneOff"
    private const val SCENE_CONFIG_KEY_NON_OFF = "nonOff"
    private const val SCENE_CONFIG_KEY_HI_OFF = "hiOff"


    // =============================================================================================


    /**
     * 获取场景是否关闭
     */
    fun isSceneOff(sceneId: String?): Boolean {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(sceneId)
            // 匹配上了
            sceneConfig?.get(SCENE_CONFIG_KEY_OFF)?.asBoolean ?: false
        }.getOrElse {
            false
        }
    }

    /**
     * 获取HiSavana广告是否关闭
     */
    fun isSceneHiOff(sceneId: String?): Boolean {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(sceneId)
            // 匹配上了
            sceneConfig?.get(SCENE_CONFIG_KEY_HI_OFF)?.asBoolean ?: false
        }.getOrElse {
            false
        }
    }

    /**
     * 获取Non广告是否关闭
     */
    fun isSceneNonOff(sceneId: String): Boolean {
        return kotlin.runCatching {
            val sceneConfig = SceneStorage.getSceneConfig(sceneId)
            sceneConfig?.get(SCENE_CONFIG_KEY_NON_OFF)?.asBoolean ?: false
        }.getOrElse {
            false
        }
    }

    /**
     * 当前场景是否关闭了
     * 统一处理多种开关
     */
    fun isSceneOffV2(sceneId: String?): String {
        if (TextUtils.isEmpty(sceneId)) {
            return "sceneId is empty"
        }

        // 当前是会员模式
        if (MemberBusinessSwitch.isSkipShowAd()) {
            val adSceneIdWhitList = MemberBusinessSwitch.getAdSceneIdWhitList()
            var isHit = false
            adSceneIdWhitList.forEach {
                if (TextUtils.equals(sceneId, it)) {
                    isHit = true
                }
            }

            if (isHit) {
                return "当前是会员 --> 当前场景ID在黑名单中"
            }
        }

        // 全局开关判断
        if (SceneGlobalConfig.isOpenAd().not()) {
            return "全局场景关闭"
        }

        // 当前场景关闭了
        if (isSceneOff(sceneId)) {
            return "场景关闭"
        }

        // 当前场景没有配置信息
        SceneStorage.getSceneConfig(sceneId) ?: return "场景配置为空"

        // 当前场景没有关闭
        return ""
    }

}