package com.transsion.ad.test

import android.os.Bundle
import android.util.Log
import androidx.lifecycle.lifecycleScope
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.nativead.BiddingNativeManager
import com.transsion.ad.databinding.ActivityTestAdNativeSspLayoutBinding
import com.transsion.ad.log.AdLogger
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/9/19 15:20
 * @description: 一次加载多个广告的测试页面
 */
class TestAdNativeSspActivity : TestBaseActivity() {

    private lateinit var nativeManager: BiddingNativeManager
    private lateinit var binding: ActivityTestAdNativeSspLayoutBinding

    private val nativeListener = object : BiddingTAdditionalListener() {

        override fun onBiddingLoad(maxEcpmObject: List<BiddingIntermediateMaterialBean>?) {
            super.onBiddingLoad(maxEcpmObject)

//            maxEcpmObject?.forEach {
//                AdLogger.logSdk(
//                    tag = AdLogger.TAG_AD_NATIVE,
//                    msg = "${it.plans?.name} ecpm = ${it.ecpm} 广告加载成功!"
//                )
//            }

            maxEcpmObject?.forEachIndexed { index, biddingIntermediateMaterialBean ->
                when (index) {
                    0 -> {
                        binding.nativeView1.bindNativeView(
                            adManager = nativeManager,
                            adLayoutProvider = TestAdNativeViewBinder(this@TestAdNativeSspActivity),
                            sspLayoutProvider = TestSspHotBiddingHiNativeSspAdLayout(this@TestAdNativeSspActivity),
                            maxEcpmObject = biddingIntermediateMaterialBean
                        )
                    }

                    1 -> {
                        binding.nativeView2.bindNativeView(
                            adManager = nativeManager,
                            adLayoutProvider = TestAdNativeViewBinder(this@TestAdNativeSspActivity),
                            sspLayoutProvider = TestSspHotBiddingHiNativeSspAdLayout(this@TestAdNativeSspActivity),
                            maxEcpmObject = biddingIntermediateMaterialBean
                        )
                    }

                    2 -> {
                        binding.nativeView3.bindNativeView(
                            adManager = nativeManager,
                            adLayoutProvider = TestAdNativeViewBinder(this@TestAdNativeSspActivity),
                            sspLayoutProvider = TestSspHotBiddingHiNativeSspAdLayout(this@TestAdNativeSspActivity),
                            maxEcpmObject = biddingIntermediateMaterialBean
                        )
                    }
                }
            }
        }

        override fun onBiddingError(p0: TAdErrorCode?) {
            super.onBiddingError(p0)
            onLog(level = Log.ERROR, msg = "onBiddingError() --> p0 = ${p0?.errorMessage}")
        }
    }


// =============================================================================================


    override fun getLogTag(): String = AdLogger.TAG_AD_NATIVE

    override fun onDestroy() {
        super.onDestroy()
        nativeManager.destroy()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdNativeSspLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        nativeManager = BiddingNativeManager()
        binding.btnLoadNativeAd.setOnClickListener {
            lifecycleScope.launch {
                nativeManager.setSceneId("MBNativeTestId")
                nativeManager.setCtxMap(null)
                nativeManager.setContext(this@TestAdNativeSspActivity)
                nativeManager.setListener(nativeListener)
                nativeManager.loadAd(fetchCount = 3)
            }
        }
    }

}