package com.transsion.ad.test

import android.os.Bundle
import com.transsion.ad.databinding.ActivityTestAdOtherConfigLayoutBinding
import com.transsion.ad.log.AdLogger
import com.transsion.ad.strategy.AdContextManager
import com.transsion.ad.strategy.NewUserShieldStrategy
import com.transsion.ad.util.TimeUtil

/**
 * @author shmizhangxinbing
 * @date : 2025/6/19 14:28
 * @description:
 */
class TestAdOtherConfigActivity : TestBaseActivity() {

    private lateinit var binding: ActivityTestAdOtherConfigLayoutBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdOtherConfigLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        val sb = StringBuilder()

        // genre
        val remoteGenre = "genre = ${AdContextManager.getRemoteGenre()}"
        sb.append(remoteGenre).append("\n").append("\n")

        // 新用户状态
        val userCreateTime = "userCreateTime = ${
            TimeUtil.convertTimestampToDate(
                NewUserShieldStrategy.getUserCreateTime(), dateFormat = "yyyy-MM-dd HH:mm:ss"
            )
        }"
        val currentTime = System.currentTimeMillis()
        val currentDate = "currentDate = ${
            TimeUtil.convertTimestampToDate(
                currentTime, dateFormat = "yyyy-MM-dd HH:mm:ss"
            )
        }"
        val newUserAdShieldHour =
            "newUserAdShieldHour = ${NewUserShieldStrategy.getNewUserAdShieldHour()} h"
        val diff = "相差 = ${
            TimeUtil.getTimeDifference(
                NewUserShieldStrategy.getUserCreateTime(), currentTime
            )
        }"
        val isNewUser = "isNewUser = ${NewUserShieldStrategy.isNewUser()}"
        sb.append(userCreateTime).append("\n")
        sb.append(currentDate).append("\n")
        sb.append(newUserAdShieldHour).append("\n")
        sb.append(diff).append("\n")
        sb.append(isNewUser).append("\n")

        // 展示日志信息
        binding.tvConfig.text = sb.toString()
    }

    override fun getLogTag(): String = AdLogger.TAG_BASE

}