package com.transsion.ad.test

import android.annotation.SuppressLint
import android.os.Bundle
import android.util.Log
import androidx.lifecycle.lifecycleScope
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.splash.BiddingSplashManager
import com.transsion.ad.databinding.ActivityTestAdSplashLayoutBinding
import com.transsion.ad.log.AdLogger
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/6/9 10:32
 * @description:
 */
@SuppressLint("CustomSplashScreen")
class TestAdSplashActivity : TestBaseActivity() {

    private lateinit var splashManager: BiddingSplashManager
    private lateinit var binding: ActivityTestAdSplashLayoutBinding

    private val splashListener = object : BiddingTAdditionalListener() {

        override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingLoad(maxEcpmObject)
            //AdLogger.logSdkSplash("${getClassTag()} --> onBiddingLoad() --> 广告加载完成，可以展示了")
            splashManager.startAdActivity(activity = this@TestAdSplashActivity,maxEcpmObject)
        }

        override fun onBiddingError(p0: TAdErrorCode?) {
            super.onBiddingError(p0)
            onLog(level = Log.ERROR, msg = "onBiddingError() --> p0 = ${p0?.errorMessage}")
        }

        override fun onBiddingWrapperAdClose(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingWrapperAdClose(maxEcpmObject)
            onLog(level = Log.ERROR, msg = "onBiddingWrapperAdClose()")
            finish()
        }
    }


    // =============================================================================================


    override fun getLogTag(): String = AdLogger.TAG_AD_SPLASH

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdSplashLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        splashManager = BiddingSplashManager()
        binding.btnLoadSplashAd.setOnClickListener {
            lifecycleScope.launch {
                splashManager.setSceneId("MBNativeTestId")
                splashManager.setCtxMap(null)
                splashManager.setContext(this@TestAdSplashActivity)
                splashManager.setListener(splashListener)
                splashManager.loadAd()
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        splashManager.destroy()
    }

}