package com.transsion.ad.util

/**
 * @author: zhangxinbing
 * @date : 2025/4/18 14:06
 * @description:
 */
internal object FastClickUtils {

    private var lastClickTime: Long = 0
    private var lastClickViewId = 0

    fun isFastClick(id: Int, time: Long): Boolean {
        if (lastClickViewId != id) {
            lastClickViewId = id
            lastClickTime = System.currentTimeMillis()
            return false
        }
        val tmp: Long = System.currentTimeMillis() - lastClickTime
        if (tmp <= time) {
            return true
        }
        lastClickViewId = id
        lastClickTime = System.currentTimeMillis()
        return false
    }
}