package com.transsion.ad.web

import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.ActivityUtils
import com.blankj.utilcode.util.Utils
import com.transsion.ad.MbAdContents
import com.transsion.ad.R
import com.transsion.ad.databinding.ActivityAdWebLayoutBinding
import com.transsion.ad.log.AdLogger
import com.transsion.ad.strategy.AdOverridePendingTransitionManager
import com.transsion.ad.util.FragmentUtils
import com.transsion.lib_web.WebConstant

/**
 * @author: zhangxinbing
 * @date : 2025/4/21 19:53
 * @description:
 */
internal class AdWebActivity : AppCompatActivity() {

    companion object {

        fun startActivity(
            url: String?, // 落地页地址
            overridePendingTransition: AdOverridePendingTransitionManager.AdOverridePendingTransitionEnum? = null, // 落地页动画效果枚举类型
            logTag: String?, // 日志标签
        ) {
            val topActivity = ActivityUtils.getTopActivity() ?: return
            val intent = Intent(topActivity, AdWebActivity::class.java)
            intent.putExtra(WebConstant.FIELD_URL, url)
            intent.putExtra(MbAdContents.WEB_ACTIVITY_EXTRA_LOG_TAG_KEY, logTag)
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            Utils.getApp().startActivity(intent)
            when (overridePendingTransition) {
                AdOverridePendingTransitionManager.AdOverridePendingTransitionEnum.OVERRIDE_PENDING_TRANSITION_1 -> {
                    topActivity.overridePendingTransition(R.anim.slide_in_from_top, R.anim.no_anim)
                }

                else -> {}
            }
        }
    }


    // =============================================================================================


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val binding = ActivityAdWebLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        // 获取传递过来的数据
        val adWebFragment = AdWebFragment()
        val bundle = Bundle()
        bundle.putString(WebConstant.FIELD_URL, intent?.getStringExtra(WebConstant.FIELD_URL))
        bundle.putString(
            MbAdContents.WEB_ACTIVITY_EXTRA_LOG_TAG_KEY,
            intent?.getStringExtra(MbAdContents.WEB_ACTIVITY_EXTRA_LOG_TAG_KEY)
        )
        adWebFragment.arguments = bundle

        // 加载页面
        adWebFragment.let {
            FragmentUtils.addFragmentSafely(
                fragmentManager = supportFragmentManager,
                containerId = R.id.flContain,
                fragment = it
            )
        }

        AdLogger.logSdk(
            tag = intent?.getStringExtra(MbAdContents.WEB_ACTIVITY_EXTRA_LOG_TAG_KEY)
                ?: AdLogger.TAG_BASE,
            msg = "AdWebActivity --> onCreate() --> 内置WebView处理广告落地页"
        )
    }
}