package com.transsion.ad.web.cct

import android.app.Activity
import android.net.Uri

/**
 * @author shmizhangxinbing
 * @date : 2025/11/14 11:15
 * @description: To be used as a fallback to open the Uri when Custom Tabs is not available.
 */
interface CustomTabFallback {

    companion object {
        const val EXTRA_URL: String = "extra.url"
    }

    /**
     * Opens a Uri using a fallback method.
     *
     * @param activity The Activity that wants to open the Uri.
     * @param uri      The uri to be opened by the fallback.
     */
    fun openUri(activity: Activity?, uri: Uri?)
}