package com.transsion.ad.monopoly.intercept

import com.blankj.utilcode.util.GsonUtils
import com.tn.lib.util.device.TNDeviceHelper
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse

/**
 * @author: zhangxinbing
 * @date : 2024/3/19 10:54
 * @description: 手机品牌白名单判断
 */
internal class BrandInWhitelistHandler : AbsAdPlanInterceptHandler() {

    /**
     * 优先判断黑名单，如果设备在黑名单中，那就直接返回--当前不匹配。
     * 白名单
     *      如果白名单不为空，需要判断当前设备是否在白名单中。
     *          在白名单中，返回匹配成功。
     *          不在白名单中，返回匹配失败。
     *      白名单为空，返回匹配成功。
     */
    override suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {

        // 服务端配置的白名单
        val plaBrand = plans?.brand
        val brandFromJson = GsonUtils.fromJson(plaBrand, Array<String>::class.java)
        if (brandFromJson.isNullOrEmpty()) {
            // 白名单为空，返回匹配成功。
            return getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        }

        // 当前手机品牌
        val currentBrand = TNDeviceHelper.getBrand()
        var isBrandInWhitelist = false
        brandFromJson.forEach {
            // 这里匹配规则需要包含
            if (it.lowercase().contains(currentBrand.lowercase()) || currentBrand.lowercase()
                    .contains(it.lowercase())
            ) {
                isBrandInWhitelist = true
            }
        }

        // 白名单不为空 且不在白名单中 返回没有匹配
        return if (isBrandInWhitelist) {
            getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        } else {
            AdPlansHitResponse(isHit = false, rejectMsg = "当前手机品牌不在白名单中")
        }

    }
}