package com.transsion.ad.monopoly.model

import android.os.Parcelable
import com.google.gson.annotations.SerializedName
import kotlinx.parcelize.Parcelize

/**
 * @author: zhangxinbing
 * @date : 2025/2/13 20:56
 * @description:
 */
@Parcelize
data class AdPlans(
    val id: String? = null, // 广告计划id
    val name: String? = null, // 广告计划名称
    val sort: Int? = Int.MAX_VALUE, // 排序
    var advertiserName: String? = null, // 广告主名称
    var advertiserAvatar: String? = null, // 广告主头像
    var advertiserAvatarPath: String? = null, // 广告主头像本地地址

    var showedTimes: Int? = null, // 已展示次数
    var showDate: String? = null, // 展示日期
    val scenes: List<String>? = null, // 广告展现场景
    val displayTimes: Int? = null, // 广告展现频次

    // 几个定向的参数，都是白名单
    // 如果返回空的，就是全部开放
    val country: List<String>? = null, // 广告定向投放国家
    val brand: List<String>? = null, // 广告定向投放设备品牌
    val denyBrand: List<String>? = null, // 广告定向投放设备品牌
    val model: List<String>? = null, // 广告定向投放机型
    val denyModel: List<String>? = null, // 广告定向投放机型
    val filterClientVersion: String? = null,// 客户端版本号定向
    val startTime: String? = null, // 广告计划开始时间
    val endTime: String? = null, // 广告计划结束时间

    val extraConfig: String? = null, // 额外配置信息，协商好json字符串，客户端解析
    var adMaterialList: List<AdMaterialList>? = null, // 广告素材列表
    val adPlanCreateTime: String? = null,// 广告计划创建时间
    val adPlanUpdateTime: String? = null, // 计划最后更新时间
    val adShowLevel: String? = null, // 广告计划状态 AdShowFirst: 优先 AdShowFinal: 兜底 default: AdShowLevelUnknown

    val appStarDesc: String? = null,// icon 类型属性 推广应用的的星数
    val appSizeDesc: String? = null,// 推广应用的的包大小

    // MovieBox会员&内容广告屏蔽策略
    // https://transsioner.feishu.cn/docx/Pj84dFtm7oSSKnxEezBcOksTnqb
    val ctxEnableExpr: String? = null, // 广告计划上下文 -- 白名单
    val ctxDisableExpr: String? = null, // 广告计划上下文 -- 黑名单
    var ctxAttributeConfig: CtxAttributeConfig? = null, // 上下文判断条件

    // 2024-12-02 新增字段
    var dispatchTimeStart: String? = null,  // 广告分发时间段开始时间
    var dispatchTimeEnd: String? = null,     // 广告分发时间段结束时间
    var adSource: String? = null,           // 广告来源 目前仅有ps一种
    var extAdSlot: String? = null,          // 广告位信息 跟着adSourcePS字段使用

    // https://transsioner.feishu.cn/docx/DQBJdEeieoT0RqxDoZ6cyKTbndh
    // 2025-03-12 新增字段
    var extImage: MbAdImage? = null, // 首页Banner展示广告计划 扩展图片

    var version: String? = null, // 广告配置版本号

    // 2025-05-28 竞价需求 增加字段 // 竞价价格
    // https://transsioner.feishu.cn/docx/UUGndRUMmok5ODxCdFXcqavEnme
    var bidEcpmCent: Double? = null, // 竞价 ecpm 单位美分
    var ecpmCent: Long? = null,    // 结算 ecpm 单位美分

    // 当前计划是否有效
    // 2025-08-05
    // https://transsioner.feishu.cn/wiki/LmKMwmS8DieGdJkMDvPczVePnph
    // 修复 广告计划更新及时性导致的展示数量丢失问题处理
    // 0 : false
    // 1 : true
    var isValid: Boolean = false,

    // 表示当前落地页是否需要预加载
    val h5LinkPreload: Boolean = false,

    // 当前链接是否需要通过CCT打开
    val h5LinkOpenByCct: Boolean = false,

    ) : Parcelable