package com.transsion.ad.ps

import android.os.Build
import com.blankj.utilcode.util.AppUtils
import com.tn.lib.util.device.TNDeviceHelper
import com.transsion.ad.MbAdContents
import com.transsion.ad.db.pslink.AttributionPoint
import com.transsion.ad.ps.model.RecommendInfo
import com.transsion.ad.report.AdReportManager

/**
 * @author: zhangxinbing
 * @date : 2025/3/19 19:53
 * @description: ps 接口状态上报
 *
 * 埋点文档
 * https://transsioner.feishu.cn/wiki/wikcn6MYuDBliQKh5Tp1GFNkowt?sheet=JaJh9j
 */
object PSReportUtil {

    /**
     * PS 直连 相关埋点
     */
    private const val PAGE_NAME_PS_DISTRIBUTE = "ps_distribute"

    /**
     * 接口请求状态
     */
    enum class PSRequestState(val value: String) {
        REQUEST_TRIGGER("trigger"), REQUEST_SUCCESS("success"), REQUEST_FAIL("fail"),
    }

    /**
     * 区分 PS HI
     */
    enum class ItemResourceEnum(val value: String) {
        ITEM_RES_HI("hi"), ITEM_RES_PS("ps"),
    }

    /**
     * 场景
     */
    enum class PsDistributeSceneEnum(val value: String) {
        PS_DISTRIBUTE_SCENE_DOWNLOAD_INTERCEPT("download_intercept"), // 下载拦截弹窗
        PS_DISTRIBUTE_SCENE_APP_CENTER("app_center"), // 下载中心
        PS_DISTRIBUTE_SCENE_DOWNLOAD_CENTER_APP("download_center_app"), // 应用下载管理中心
        PS_DISTRIBUTE_SCENE_AD_PLAN("ad_plan"), // 虚拟计划
    }


    // =============================================================================================


    /**
     * PS 商单触发请求、结果、错误
     */
    fun reportPsLinkRequest(
        psState: PSRequestState,
        count: Int? = null,
        errorMsg: String? = null,
        psScene: String? = null,
        scene: String,
    ) {
        val map = mutableMapOf<String, Any?>()
        map["ps_state"] = psState.value  // 状态 1.触发 2.请求成功--返回数量 3.请求失败原因
        map["count"] = count.toString()  // PS接口返回的数量
        map["error_msg"] = errorMsg.toString() // 错误信息
        map["ps_scene"] = psScene.toString() // 样式/场景 用于虚拟计划
        map["scene"] = scene // 哪里触发的 页面信息
        map["action"] = "ps_request" // 请求

        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = PAGE_NAME_PS_DISTRIBUTE
        )
    }

    /**
     * 素材下载状态上报
     */
    fun reportMaterialState(
        psState: PSRequestState, recommendInfo: RecommendInfo?, sceneStr: String, adPlanId: String
    ) {
        val map = mutableMapOf<String, Any?>()
        map["scene"] = sceneStr // PS 的场景
        map["ad_planId"] = adPlanId // 虚拟计划
        map["ps_state"] = psState.value  // 状态 1.触发 2.请求成功--返回数量 3.请求失败原因
        map["id"] = recommendInfo?.id?.toString()
        map["action"] = "ps_material" // 素材
        //commonParams(map = map, recommendInfo = recommendInfo) // 配置信息
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = PAGE_NAME_PS_DISTRIBUTE
        )
    }

    /**
     * PS 归因，MB同步上报数据校验
     */
    fun onPsAttribution(type: AttributionPoint.AttributionType?, psId: String?) {
        val map = mutableMapOf<String, Any?>()
        map["type"] = type?.name
        map["psId"] = psId
        map["action"] = "ps_attribution" // 素材
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = "ps_attribution"
        )
    }


    // =============================================================================================


    @Deprecated("统一走广告埋点")
    private fun commonParams(map: MutableMap<String, Any?>, recommendInfo: RecommendInfo?) {
        map["gaid"] = TNDeviceHelper.getGaid()
        map["country_code"] = TNDeviceHelper.getCountry()
        map["media"] = AppUtils.getAppName()
        //map["scene"] = scene
        //map["style"] = PsLinkAppsLayoutConfig.getLayoutStyle()
        map["app_name"] = recommendInfo?.detail?.name.toString()
        map["packageName"] = recommendInfo?.packageName.toString()
        map["ps_dialog_style"] = PsLinkUtils.PS_LINK_DIALOG_STYLE
        map["plan_Name"] = recommendInfo?.planName.toString()
        map["plan_id"] = recommendInfo?.id.toString()
        map["is_offer"] = recommendInfo?.isOffer.toString()
        map["show_type"] = recommendInfo?.showType.toString()
        map["ua"] = Build.MODEL
        map["brand"] = Build.BRAND
        map["source"] = "ps"
        map["adSource"] = recommendInfo?.adSource.toString()
    }

    /**
     * 点击事件
     */
    @Deprecated("统一走广告埋点")
    fun click(
        scene: String, // 样式/场景
        resource: String, // 来源
        recommendInfo: RecommendInfo?
    ) {
        val map = mutableMapOf<String, Any?>()
        map["scene"] = scene
        map["resource"] = resource
        map["action"] = "click" // 素材点击
        //map["id"] = recommendInfo?.id?.toString() ?: ""
        commonParams(map = map, recommendInfo = recommendInfo)
        AdReportManager.onReport(
            event = "click", map = map, pageName = PAGE_NAME_PS_DISTRIBUTE
        )
    }

    /**
     * 曝光事件
     */
    @Deprecated("统一走广告埋点")
    fun browse(
        scene: String, // 样式/场景
        resource: String, recommendInfo: RecommendInfo?
    ) {
        val map = mutableMapOf<String, Any?>()
        map["scene"] = scene
        map["resource"] = resource
        map["action"] = "display" // 请求
        //map["id"] = recommendInfo?.id?.toString() ?: ""
        commonParams(map = map, recommendInfo = recommendInfo)
        AdReportManager.onReport(
            event = "browse", map = map, pageName = PAGE_NAME_PS_DISTRIBUTE
        )
    }
}