package com.transsion.ad.report

import android.os.Build
import android.text.TextUtils
import com.blankj.utilcode.util.AppUtils
import com.tn.lib.util.device.TNDeviceHelper
import com.transsion.ad.MbAdContents
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.ps.PsLinkUtils
import com.transsion.ad.ps.model.RecommendInfo
import com.transsion.ad.scene.SceneGlobalConfig
import org.json.JSONObject

/**
 * @author: zhangxinbing
 * @date : 2023/12/12 13:55
 * @description:
 */
object AdReportProvider {

    private const val AD_STATE_TYPE_TRIGGER = "trigger" // 触发
    private const val AD_STATE_TYPE_DISPLAY = "display" // 展示
    private const val AD_STATE_TYPE_CLICK = "click" // 点击
    private const val AD_STATE_TYPE_SHOW_TIME = "show_time" // 展示时间

    /**
     * int SSP = 0;
    int ADMOB = 1;
    int FAN = 2;
    /**
     * 1.4.0 新增的广告源
    */
    int APPLOVIN = 3;

    int UNITY = 4;

    /**
     * 新增广告源 141 2022-5-25
    */
    int IRON_SOURCE = 5;

    /****2022-07-05 inmobi*/
    int INMOBI = 8;
    /**
     * 143新增广告源
    */
    int VUNGLE = 12;
    int ADCOLONY = 11;
    //2.0.3.0新增广告源
    int PANGLE = 6;
    //2.1.1.0新增广告源
    int MINTEGRAL = 9;
     */
    private const val AD_MAP_AD_SOURCE = "adSource"
    private const val AD_MAP_ACTION = "action"
    private const val AD_MAP_AD_TYPE = "adType"

    private const val AD_MAP_AD_ID = "ad_id"
    private const val AD_MAP_PLAN_ID = "plan_id"
    private const val AD_MAP_AD_PLAN_ID = "ad_plan_id"
    private const val AD_MAP_SCENE_ID = "scene_id"
    private const val AD_MAP_TRIGGER_ID = "trigger_id"

    //private const val AD_MAP_SOURCE = "ad_source"
    private const val AD_MAP_IS_AD_SHOW_FINAL = "is_ad_show_final"


    // =============================================================================================


    /**
     * 业务场景触发 -- 这里指的是业务场景触发展示广告不是加载
     */
    fun trigger(
        triggerId: String = "",
        sceneId: String,
        @MbAdType adType: Int,
        @MbAdSource adSource: Int,
        planId: String?,
        sceneSubId: String? = null,               // 子场景ID
    ) {
        val map = mutableMapOf<String, Any?>()
        map[AD_MAP_ACTION] = AD_STATE_TYPE_TRIGGER
        map[AD_MAP_AD_TYPE] = adType.toString()
        //map[AD_MAP_PAGE_NAME] = sceneId 2075版本开始废弃了
        map[AD_MAP_SCENE_ID] = sceneId
        map[AD_MAP_PLAN_ID] = planId
        map[AD_MAP_AD_SOURCE] = adSource.toString()
        map[AD_MAP_TRIGGER_ID] = triggerId

        if (TextUtils.isEmpty(sceneSubId).not()) {
            map["scene_sub_id"] = sceneSubId
        }

        // 埋点是有开关的
        if (SceneGlobalConfig.isAdTriggerClosed()) {
            AdLogger.logSdk(
                tag = AdLogger.TAG_BASE,
                "AdReportProvider --> trigger() --> 广告数据上报链路已关闭，不上报 -- map = $map"
            )
            return
        }

        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * 广告加载拒绝
     */
    fun reject(
        triggerId: String = "",
        sceneId: String,
        @MbAdType adType: Int,
        @MbAdSource adSource: Int,
        rejectMsg: String?,
        sceneSubId: String? = null,               // 子场景ID
    ) {
        val map = mutableMapOf<String, Any?>()
        map[AD_MAP_ACTION] = "reject"
        map[AD_MAP_TRIGGER_ID] = triggerId
        map[AD_MAP_AD_TYPE] = adType.toString()
        map[AD_MAP_SCENE_ID] = sceneId
        map["reject_msg"] = rejectMsg
        map[AD_MAP_AD_SOURCE] = adSource.toString()

        if (TextUtils.isEmpty(sceneSubId).not()) {
            map["scene_sub_id"] = sceneSubId
        }

        // 埋点是有开关的
        if (SceneGlobalConfig.isAdadRejectOffClosed()) {
            AdLogger.logSdk(
                tag = AdLogger.TAG_BASE,
                "AdReportProvider --> reject() --> 广告数据上报链路已关闭，不上报 -- map = $map"
            )
            return
        }

        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * 竞价结果
     */
    fun biddingReport(
        triggerId: String = "",           // 触发ID
        sceneId: String,                  // 场景ID
        @MbAdType adType: Int,            // 广告类型
        result: BiddingStateEnum?,        // 竞价结果
        msg: String?,                     // 失败原因
        ecpmList: String?,                // 参与竞价的列表
        ecpm: String?,                    // ecpm
        planId: String?,                  // 广告计划ID
        planName: String?,                // 广告计划名字
        sceneSubId: String?,              // 子场景ID
    ) {
        val map = mutableMapOf<String, Any?>()
        map[AD_MAP_ACTION] = "bidding"
        map[AD_MAP_TRIGGER_ID] = triggerId
        map[AD_MAP_AD_TYPE] = adType.toString()
        map[AD_MAP_SCENE_ID] = sceneId
        map["result"] = result?.value
        map["msg"] = msg
        map["ecpm_list"] = ecpmList
        map["ecpm"] = ecpm
        map["plan_id"] = planId
        map["plan_name"] = planName

        if (TextUtils.isEmpty(sceneSubId).not()) {
            map["scene_sub_id"] = sceneSubId
        }

        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * 广告展示 -- 依赖广告SDK回调
     */
    fun display(
        triggerId: String = "",
        sceneId: String?,
        adPlanId: String?,
        adSource: Int?,
        adId: String?,
        @MbAdType adType: Int,
        isAdShowFinal: Boolean = false,
        extMap: Map<String, String> = emptyMap(),
        //psId: Long?,
        //psPackageName: String? = null,
        psRecommendInfo: RecommendInfo?,
        bidEcpmCent: Double? = null,
        ecpmCent: Long? = null,
        sceneSubId: String? = null,               // 子场景ID
    ) {
        val map = mutableMapOf<String, Any?>()
        map[AD_MAP_AD_SOURCE] = adSource.toString()
        map[AD_MAP_AD_TYPE] = adType.toString()
        map[AD_MAP_ACTION] = AD_STATE_TYPE_DISPLAY
        map[AD_MAP_AD_ID] = adId ?: ""
        map[AD_MAP_AD_PLAN_ID] = adPlanId ?: ""
        map[AD_MAP_SCENE_ID] = sceneId ?: ""
        map[AD_MAP_IS_AD_SHOW_FINAL] = isAdShowFinal.toString()
        map[AD_MAP_TRIGGER_ID] = triggerId

        // PS 相关
        commonParams(map = map, recommendInfo = psRecommendInfo)

        // ecpm
        map["bid_ecpm_cent"] = bidEcpmCent.toString()
        map["ecpm_cent"] = ecpmCent.toString()

        if (TextUtils.isEmpty(sceneSubId).not()) {
            map["scene_sub_id"] = sceneSubId
        }

        if (extMap.isNotEmpty()) {
            map.putAll(extMap)
        }
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * 广告点击了 -- 依赖广告SDK回调
     */
    fun adClick(
        triggerId: String = "",
        sceneId: String?,
        adPlanId: String?,
        adSource: Int?,
        adId: String?,
        @MbAdType adType: Int,
        isAdShowFinal: Boolean = false,
        extMap: Map<String, String> = emptyMap(),
        //psId: Long?,
        //psPackageName: String? = null,
        psRecommendInfo: RecommendInfo?,
        bidEcpmCent: Double? = null,
        ecpmCent: Long? = null,
        sceneSubId: String? = null,               // 子场景ID
    ) {
        val map = mutableMapOf<String, Any?>()
        map[AD_MAP_AD_SOURCE] = adSource.toString()
        map[AD_MAP_AD_TYPE] = adType.toString()
        map[AD_MAP_ACTION] = AD_STATE_TYPE_CLICK
        map[AD_MAP_AD_ID] = adId ?: ""
        map[AD_MAP_AD_PLAN_ID] = adPlanId ?: ""
        map[AD_MAP_SCENE_ID] = sceneId ?: ""
        map[AD_MAP_IS_AD_SHOW_FINAL] = isAdShowFinal.toString()
        map[AD_MAP_TRIGGER_ID] = triggerId

        // PS 相关
        //map["ps_id"] = psId.toString()
        //map["ps_package_name"] = psPackageName.toString()
        commonParams(map = map, recommendInfo = psRecommendInfo)

        // ecpm
        map["bid_ecpm_cent"] = bidEcpmCent.toString()
        map["ecpm_cent"] = ecpmCent.toString()

        if (TextUtils.isEmpty(sceneSubId).not()) {
            map["scene_sub_id"] = sceneSubId
        }

        if (extMap.isNotEmpty()) {
            map.putAll(extMap)
        }
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }

    /**
     * - 广告平均单次展现时长
     */
    fun adShowTime(
        triggerId: String = "",
        sceneId: String?,
        adPlanId: String?,
        displayTime: Long,
        adId: String?,
        @MbAdType adType: Int,
        isAdShowFinal: Boolean = false,
        sceneSubId: String? = null,               // 子场景ID
    ) {
        val map = mutableMapOf<String, Any?>()
        map[AD_MAP_AD_SOURCE] = MbAdSource.MB_AD_SOURCE_BUY_OUT.toString()
        map[AD_MAP_AD_TYPE] = adType.toString()
        map[AD_MAP_ACTION] = AD_STATE_TYPE_SHOW_TIME
        map[AD_MAP_AD_ID] = adId ?: ""
        map[AD_MAP_AD_PLAN_ID] = adPlanId ?: ""
        map[AD_MAP_SCENE_ID] = sceneId ?: ""
        map[AD_MAP_IS_AD_SHOW_FINAL] = isAdShowFinal.toString()
        map[AD_MAP_TRIGGER_ID] = triggerId
        map["duration"] = displayTime.toString()

        if (TextUtils.isEmpty(sceneSubId).not()) {
            map["scene_sub_id"] = sceneSubId
        }

        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = sceneId
        )
    }


    // =============================================================================================


    /**
     * 广告计划触达率
     *
     * 客户端接收到服务端，服务端去重DAU
     *
     * @param newVersion 当前字幕版本号
     */
    fun onNewAdPlanReceive(lastVersion: String?, newVersion: String?) {
        val map = mutableMapOf<String, Any?>()
        map["last_version"] = lastVersion.toString()
        map["new_version"] = newVersion.toString()
        map[AD_MAP_ACTION] = "plan_receive"
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = "ad_config"
        )
    }

    /**
     * 广告计划更新率
     *
     * 新版本字幕更新成功上报埋点，服务端去重DAU
     *
     * @param version 当前字幕版本号
     */
    fun onNewAdPlanUpdateSuccess(lastVersion: String?, newVersion: String?) {
        val map = mutableMapOf<String, Any?>()
        map["last_version"] = lastVersion.toString()
        map["new _version"] = newVersion.toString()
        map[AD_MAP_ACTION] = "plan_success"
        AdReportManager.onReport(
            event = MbAdContents.AD_EVENT_AD_LINK, map = map, pageName = "ad_config"
        )
    }


    // =============================================================================================


    /**
     * PS 广告埋点上报
     */
    private fun commonParams(map: MutableMap<String, Any?>, recommendInfo: RecommendInfo?) {
        if (recommendInfo == null) {
            return
        }
        runCatching {
            val psMap = mutableMapOf<String, String?>()
            psMap["gaid"] = TNDeviceHelper.getGaid()
            psMap["country_code"] = TNDeviceHelper.getCountry()
            psMap["media"] = AppUtils.getAppName()
            //psMap["scene"] = scene
            //psMap["style"] = PsLinkAppsLayoutConfig.getLayoutStyle()
            psMap["app_name"] = recommendInfo.detail?.name.toString()
            psMap["packageName"] = recommendInfo.packageName.toString()
            psMap["ps_dialog_style"] = PsLinkUtils.PS_LINK_DIALOG_STYLE
            psMap["plan_Name"] = recommendInfo.planName.toString()
            psMap["plan_id"] = recommendInfo.id.toString()
            psMap["is_offer"] = recommendInfo.isOffer.toString()
            psMap["show_type"] = recommendInfo.showType.toString()
            psMap["ua"] = Build.MODEL
            psMap["brand"] = Build.BRAND
            psMap["source"] = "ps"
            psMap["adSource"] = recommendInfo.adSource.toString()

            val psMapJson = JSONObject(psMap)
            map["ps_map_json"] = psMapJson

            // 兼容历史版本解析逻辑
            //psId = AdPlanUtil.getPsId(maxEcpmObject?.plans),
            //psPackageName = AdPlanUtil.getPsPackageName(maxEcpmObject?.plans),
            map["ps_id"] = recommendInfo.id.toString()
            map["ps_package_name"] = recommendInfo.packageName.toString()
        }.getOrElse {
            AdLogger.logCommon("AdReportProvider --> commonParams() --> ${it.message}")
        }
    }
}