package com.transsion.ad.test

import android.os.Bundle
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.blankj.utilcode.util.GsonUtils
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.google.gson.GsonBuilder
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import com.transsion.ad.R
import com.transsion.ad.databinding.ActivityTestAdSceneLayoutBinding
import com.transsion.ad.log.AdLogger
import com.transsion.ad.scene.SceneStorage
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

/**
 * @author shmizhangxinbing
 * @date : 2025/6/19 14:28
 * @description:
 */
class TestAdSceneActivity : TestBaseActivity() {

    private lateinit var binding: ActivityTestAdSceneLayoutBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdSceneLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        // 按钮
        binding.btn.setOnClickListener {
            lifecycleScope.launch {
                withContext(Dispatchers.IO) {
                    AdLogger.logCommon(
                        msg = "TestAdPlansActivity --> toJson = ${
                            formatJson(
                                SceneStorage.getSceneConfig()
                            )
                        }"
                    )
                }
            }
        }

        // 版本号
        val vc = "版本号 ${SceneStorage.getSceneVersion()}"
        binding.tvTitle.text = vc

        // 列表
        val mAdPlanAdapter = AdPlansAdapter()
        binding.rv.apply {
            layoutManager = LinearLayoutManager(this@TestAdSceneActivity)
            adapter = mAdPlanAdapter
        }

        val sceneConfig = SceneStorage.getSceneConfig()
        val array = GsonUtils.fromJson(sceneConfig, JsonArray::class.java)
        val sceneList = mutableListOf<JsonObject?>()
        array?.forEach {
            sceneList.add(it?.asJsonObject)
        }
        mAdPlanAdapter.setList(sceneList)
    }

    override fun getLogTag(): String = AdLogger.TAG_BASE

    private fun formatJson(json: String?): String {
        val gson = GsonBuilder().setPrettyPrinting().create()
        try {
            // 解析 JSON 字符串并格式化
            val jsonElement = gson.fromJson(json, Any::class.java)
            return gson.toJson(jsonElement)
        } catch (e: Exception) {
            e.printStackTrace()
            return "Invalid JSON String"
        }
    }


    // =============================================================================================


    class AdPlansAdapter :
        BaseQuickAdapter<JsonObject?, BaseViewHolder>(R.layout.test_item_ad_plan_layout) {

        override fun convert(holder: BaseViewHolder, item: JsonObject?) {
            val prettyJson = item?.let {
                GsonBuilder().setPrettyPrinting() // 启用格式化输出
                    .create().toJson(it)
            } ?: ""

            holder.setText(R.id.tvConfig, prettyJson)
        }
    }
}